/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.routing;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.SerializationUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsCollectionWithSize;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.mule.functional.api.component.TestConnectorQueueHandler;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.serialization.SerializationException;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.api.store.SimpleMemoryObjectStore;
import org.mule.runtime.core.internal.routing.EventGroup;
import org.mule.test.AbstractIntegrationTestCase;

@Ignore(value="MULE-13517: ignored as part of the spike. Needs review")
public class CollectionAggregatorRouterSerializationTestCase
extends AbstractIntegrationTestCase {
    protected String getConfigFile() {
        return "collection-aggregator-router-serialization.xml";
    }

    protected Map<String, Object> getStartUpRegistryObjects() {
        HashMap<String, Object> registryObjects = new HashMap<String, Object>();
        registryObjects.put("_defaultInMemoryObjectStore", (Object)new EventGroupSerializerObjectStore());
        return registryObjects;
    }

    @Test
    public void eventGroupDeserialization() throws Exception {
        List<String> list = Arrays.asList("first", "second");
        ((FlowRunner)this.flowRunner("splitter").withPayload(list)).run();
        TestConnectorQueueHandler queueHandler = new TestConnectorQueueHandler(this.registry);
        Message request = queueHandler.read("out", 5000L).getMessage();
        Assert.assertNotNull((Object)request);
        Assert.assertThat((Object)request.getPayload().getValue(), (Matcher)CoreMatchers.instanceOf(List.class));
        Assert.assertThat((Object)((List)request.getPayload().getValue()), (Matcher)IsCollectionWithSize.hasSize((int)list.size()));
    }

    private class EventGroupSerializerObjectStore
    extends SimpleMemoryObjectStore<Serializable> {
        private EventGroupSerializerObjectStore() {
        }

        protected void doStore(String key, Serializable value) throws ObjectStoreException {
            if (value instanceof EventGroup) {
                value = SerializationUtils.serialize((Serializable)value);
            }
            super.doStore(key, (Serializable)value);
        }

        protected Serializable doRetrieve(String key) throws ObjectStoreException {
            Object value = super.doRetrieve(key);
            if (value instanceof byte[]) {
                try {
                    value = SerializationUtils.deserialize((byte[])((byte[])value));
                }
                catch (SerializationException serializationException) {
                    // empty catch block
                }
            }
            return value;
        }
    }
}

