/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.routing;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.functional.api.component.FunctionalTestProcessor;
import org.mule.functional.api.component.TestConnectorQueueHandler;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.notification.IntegerAction;
import org.mule.runtime.api.notification.NotificationListener;
import org.mule.runtime.api.notification.RoutingNotification;
import org.mule.runtime.api.notification.RoutingNotificationListener;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.test.AbstractIntegrationTestCase;

public class CollectionAggregatorRouterTimeoutTestCase
extends AbstractIntegrationTestCase {
    protected String getConfigFile() {
        return "collection-aggregator-router-timeout-test-flow.xml";
    }

    @Test
    public void testNoFailOnTimeout() throws Exception {
        final AtomicInteger correlationTimeoutCount = new AtomicInteger(0);
        this.notificationListenerRegistry.registerListener((NotificationListener)new RoutingNotificationListener<RoutingNotification>(){

            public boolean isBlocking() {
                return false;
            }

            public void onNotification(RoutingNotification notification) {
                if (new IntegerAction(1303).equals((Object)notification.getAction())) {
                    correlationTimeoutCount.incrementAndGet();
                }
            }
        });
        FunctionalTestProcessor vortex = FunctionalTestProcessor.getFromFlow((ConfigurationComponentLocator)this.locator, (String)"vortex");
        final FunctionalTestProcessor aggregator = FunctionalTestProcessor.getFromFlow((ConfigurationComponentLocator)this.locator, (String)"aggregator");
        List<String> list = Arrays.asList("first", "second");
        ((FlowRunner)this.flowRunner("splitter").withPayload(list)).run();
        Thread.sleep(5000L);
        Assert.assertThat((String)"GroupCorrelation timeout should not have happened.", (Object)correlationTimeoutCount.intValue(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((String)"Vortex received wrong number of messages.", (Object)vortex.getReceivedMessagesCount(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((String)"Wrong message received", (Object)vortex.getLastReceivedMessage().getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"second"));
        Assert.assertThat((String)"Aggregator received wrong number of messages.", (Object)aggregator.getReceivedMessagesCount(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((String)"Wrong message received", (Object)((Message)((List)aggregator.getLastReceivedMessage().getMessage().getPayload().getValue()).get(0)).getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"first"));
        new PollingProber(10000L, 200L).check(new Probe(){

            public boolean isSatisfied() {
                return aggregator.getReceivedMessagesCount() == 1;
            }

            public String describeFailure() {
                return "Other messages never received by aggregator.";
            }
        });
        TestConnectorQueueHandler queueHandler = new TestConnectorQueueHandler(this.registry);
        Assert.assertThat((Object)queueHandler.read("out", 5000L), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }
}

