/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.routing;

import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.functional.api.component.FunctionalTestProcessor;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.functional.junit4.matchers.MessageMatchers;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.tck.junit4.matcher.EventMatcher;
import org.mule.test.AbstractIntegrationTestCase;

public class CorrelationResequencerTestCase
extends AbstractIntegrationTestCase {
    private CountDownLatch receiveLatch = new CountDownLatch(6);

    protected String getConfigFile() {
        return "correlation-resequencer-test-flow.xml";
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        FunctionalTestProcessor.getFromFlow((ConfigurationComponentLocator)this.locator, (String)"sorted").setEventCallback((context, component, muleContext) -> this.receiveLatch.countDown());
    }

    @Test
    public void testResequencer() throws Exception {
        ((FlowRunner)this.flowRunner("splitter").withPayload(Arrays.asList("a", "b", "c", "d", "e", "f"))).run();
        FunctionalTestProcessor resequencer = FunctionalTestProcessor.getFromFlow((ConfigurationComponentLocator)this.locator, (String)"sorted");
        Assert.assertTrue((boolean)this.receiveLatch.await(3000L, TimeUnit.SECONDS));
        Assert.assertEquals((String)"Wrong number of messages received.", (long)6L, (long)resequencer.getReceivedMessagesCount());
        Assert.assertThat((String)"Sequence wasn't reordered.", (Object)resequencer.getReceivedMessage(1), (Matcher)EventMatcher.hasMessage((Matcher)MessageMatchers.hasPayload((Matcher)Matchers.is((Object)"a"))));
        Assert.assertThat((String)"Sequence wasn't reordered.", (Object)resequencer.getReceivedMessage(2), (Matcher)EventMatcher.hasMessage((Matcher)MessageMatchers.hasPayload((Matcher)Matchers.is((Object)"b"))));
        Assert.assertThat((String)"Sequence wasn't reordered.", (Object)resequencer.getReceivedMessage(3), (Matcher)EventMatcher.hasMessage((Matcher)MessageMatchers.hasPayload((Matcher)Matchers.is((Object)"c"))));
        Assert.assertThat((String)"Sequence wasn't reordered.", (Object)resequencer.getReceivedMessage(4), (Matcher)EventMatcher.hasMessage((Matcher)MessageMatchers.hasPayload((Matcher)Matchers.is((Object)"d"))));
        Assert.assertThat((String)"Sequence wasn't reordered.", (Object)resequencer.getReceivedMessage(5), (Matcher)EventMatcher.hasMessage((Matcher)MessageMatchers.hasPayload((Matcher)Matchers.is((Object)"e"))));
        Assert.assertThat((String)"Sequence wasn't reordered.", (Object)resequencer.getReceivedMessage(6), (Matcher)EventMatcher.hasMessage((Matcher)MessageMatchers.hasPayload((Matcher)Matchers.is((Object)"f"))));
    }
}

