/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.routing;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.RandomStringUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.functional.api.component.FunctionalTestProcessor;
import org.mule.functional.api.component.InvocationCountMessageProcessor;
import org.mule.functional.api.exception.FunctionalTestException;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.functional.junit4.TestLegacyMessageUtils;
import org.mule.functional.junit4.matchers.ThrowableCauseMatcher;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.retry.policy.RetryPolicyExhaustedException;
import org.mule.tck.probe.JUnitLambdaProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.test.AbstractIntegrationTestCase;

@Feature(value="Routers")
@Story(value="Until Successful")
public class UntilSuccessfulTestCase
extends AbstractIntegrationTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private FunctionalTestProcessor targetMessageProcessor;

    protected String getConfigFile() {
        return "until-successful-test.xml";
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.targetMessageProcessor = FunctionalTestProcessor.getFromFlow((ConfigurationComponentLocator)this.locator, (String)"target-mp");
    }

    @Test
    public void defaultConfiguration() throws Exception {
        String payload = RandomStringUtils.randomAlphanumeric((int)20);
        ((FlowRunner)this.flowRunner("minimal-config").withPayload((Object)payload)).run();
        List<Object> receivedPayloads = this.ponderUntilMessageCountReceivedByTargetMessageProcessor(1);
        Assert.assertThat(receivedPayloads, (Matcher)IsCollectionWithSize.hasSize((int)1));
        Assert.assertThat((Object)receivedPayloads.get(0), (Matcher)Is.is((Object)payload));
    }

    @Test
    public void fullConfigurationMP() throws Exception {
        String payload = RandomStringUtils.randomAlphanumeric((int)20);
        Message response = ((FlowRunner)this.flowRunner("full-config-with-mp").withPayload((Object)payload)).run().getMessage();
        Assert.assertThat((Object)this.getPayloadAsString(response), (Matcher)Is.is((Object)"ACK"));
        List<Object> receivedPayloads = this.ponderUntilMessageCountReceivedByTargetMessageProcessor(3);
        Assert.assertThat(receivedPayloads, (Matcher)IsCollectionWithSize.hasSize((int)3));
        for (int i = 0; i <= 2; ++i) {
            Assert.assertThat((Object)receivedPayloads.get(i), (Matcher)Is.is((Object)payload));
        }
        this.ponderUntilMessageCountReceivedByCustomMP(1);
        Throwable error = TestLegacyMessageUtils.getExceptionPayload((Message)CustomMP.getProcessedEvents().get(0).getMessage()).getException();
        Assert.assertThat((Object)error, (Matcher)Is.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)error.getCause(), (Matcher)CoreMatchers.instanceOf(RetryPolicyExhaustedException.class));
        Assert.assertThat((Object)error.getCause().getMessage(), (Matcher)CoreMatchers.containsString((String)"'until-successful' retries exhausted. Last exception message was: Value was expected to be true but it was false instead"));
        Assert.assertThat((Object)error.getCause().getCause(), (Matcher)CoreMatchers.instanceOf(MuleRuntimeException.class));
        Assert.assertThat((Object)error.getCause().getMessage(), (Matcher)CoreMatchers.containsString((String)"Value was expected to be true but it was false instead"));
    }

    @Test
    public void retryOnEndpoint() throws Exception {
        String payload = RandomStringUtils.randomAlphanumeric((int)20);
        ((FlowRunner)this.flowRunner("retry-endpoint-config").withPayload((Object)payload)).run();
        List<Object> receivedPayloads = this.ponderUntilMessageCountReceivedByTargetMessageProcessor(3);
        Assert.assertThat(receivedPayloads, (Matcher)IsCollectionWithSize.hasSize((int)3));
        for (int i = 0; i <= 2; ++i) {
            Assert.assertThat((Object)receivedPayloads.get(i), (Matcher)Is.is((Object)payload));
        }
    }

    @Test
    public void executeSynchronously() throws Exception {
        String payload = RandomStringUtils.randomAlphanumeric((int)20);
        this.expectedException.expectCause(CoreMatchers.instanceOf(RetryPolicyExhaustedException.class));
        this.expectedException.expectCause(ThrowableCauseMatcher.hasCause((Matcher)CoreMatchers.instanceOf(FunctionalTestException.class)));
        ((FlowRunner)this.flowRunner("synchronous").withPayload((Object)payload)).run();
    }

    @Test
    public void executeSynchronouslyDoingRetries() throws Exception {
        String payload = RandomStringUtils.randomAlphanumeric((int)20);
        ((FlowRunner)this.flowRunner("synchronous-with-retry").withPayload((Object)payload)).runExpectingException();
        Assert.assertThat((Object)InvocationCountMessageProcessor.getNumberOfInvocationsFor((String)"untilSuccessful"), (Matcher)Is.is((Object)4));
        Assert.assertThat((Object)InvocationCountMessageProcessor.getNumberOfInvocationsFor((String)"exceptionStrategy"), (Matcher)Is.is((Object)1));
    }

    @Test
    public void measureSynchronousWait() throws Exception {
        String payload = RandomStringUtils.randomAlphanumeric((int)20);
        ((FlowRunner)this.flowRunner("measureSynchronousWait").withPayload((Object)payload)).runExpectingException();
        Assert.assertThat((Object)(WaitMeasure.totalWait >= 1000L ? 1 : 0), (Matcher)Is.is((Object)true));
    }

    private List<Object> ponderUntilMessageCountReceivedByTargetMessageProcessor(int expectedCount) throws InterruptedException {
        return this.ponderUntilMessageCountReceived(expectedCount, this.targetMessageProcessor);
    }

    private List<Object> ponderUntilMessageCountReceived(int expectedCount, FunctionalTestProcessor ftc) throws InterruptedException {
        ArrayList<Object> results = new ArrayList<Object>();
        new PollingProber(5000L, 200L).check((Probe)new JUnitLambdaProbe(() -> {
            Assert.assertThat((Object)ftc.getReceivedMessagesCount(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(expectedCount)));
            return true;
        }));
        for (int i = 0; i < ftc.getReceivedMessagesCount(); ++i) {
            results.add(ftc.getReceivedMessage(1 + i).getMessage().getPayload().getValue());
        }
        return results;
    }

    private void ponderUntilMessageCountReceivedByCustomMP(int expectedCount) throws InterruptedException {
        new PollingProber(5000L, 200L).check((Probe)new JUnitLambdaProbe(() -> {
            Assert.assertThat((Object)CustomMP.getCount(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(expectedCount)));
            return true;
        }));
    }

    public static class WaitMeasure
    implements Processor {
        public static long totalWait;
        private long firstAttemptTime = 0L;

        public CoreEvent process(CoreEvent event) throws MuleException {
            if (this.firstAttemptTime == 0L) {
                this.firstAttemptTime = System.currentTimeMillis();
            } else {
                totalWait = System.currentTimeMillis() - this.firstAttemptTime;
            }
            return event;
        }
    }

    public static class CustomMP
    implements Processor {
        private static List<CoreEvent> processedEvents = new ArrayList<CoreEvent>();

        public static void clearCount() {
            processedEvents.clear();
        }

        public static int getCount() {
            return processedEvents.size();
        }

        public static List<CoreEvent> getProcessedEvents() {
            return processedEvents;
        }

        public CoreEvent process(CoreEvent event) throws MuleException {
            processedEvents.add(event);
            return event;
        }
    }
}

