/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.spring.security;

import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.extension.http.api.HttpResponseAttributes;
import org.mule.functional.api.component.TestConnectorQueueHandler;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.notification.NotificationListener;
import org.mule.runtime.api.notification.SecurityNotification;
import org.mule.runtime.api.notification.SecurityNotificationListener;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.test.AbstractIntegrationTestCase;

public class SecureHttpPollingFunctionalTestCase
extends AbstractIntegrationTestCase {
    @Rule
    public DynamicPort port1 = new DynamicPort("port1");

    protected String[] getConfigFiles() {
        return new String[]{"org/mule/test/spring/security/secure-http-polling-server-flow.xml", "org/mule/test/spring/security/secure-http-polling-client-flow.xml"};
    }

    @Test
    public void testPollingHttpConnectorSentCredentials() throws Exception {
        final Latch latch = new Latch();
        this.notificationListenerRegistry.registerListener((NotificationListener)new SecurityNotificationListener<SecurityNotification>(){

            public boolean isBlocking() {
                return false;
            }

            public void onNotification(SecurityNotification notification) {
                latch.countDown();
            }
        });
        TestConnectorQueueHandler queueHandler = new TestConnectorQueueHandler(this.registry);
        Message result = queueHandler.read("toclient", 5000L).getMessage();
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)result.getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"foo"));
        result = queueHandler.read("toclient2", 1000L).getMessage();
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)result.getAttributes().getValue(), (Matcher)CoreMatchers.instanceOf(HttpResponseAttributes.class));
        Assert.assertThat((Object)((HttpResponseAttributes)result.getAttributes().getValue()).getStatusCode(), (Matcher)CoreMatchers.is((Object)HttpConstants.HttpStatus.UNAUTHORIZED.getStatusCode()));
        Assert.assertThat((Object)latch.await(1000L, TimeUnit.MILLISECONDS), (Matcher)CoreMatchers.is((Object)true));
    }
}

