/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.transformers;

import java.nio.charset.Charset;
import org.junit.Assert;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.transformer.AbstractTransformer;
import org.mule.runtime.core.api.transformer.DiscoverableTransformer;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.test.AbstractIntegrationTestCase;

public class GraphTransformerResolutionTestCase
extends AbstractIntegrationTestCase {
    protected String getConfigFile() {
        return "org/mule/test/transformers/graph-transformer-resolution-config.xml";
    }

    @Test
    public void resolvesNonDirectTransformation() throws Exception {
        CoreEvent muleEvent = ((FlowRunner)this.flowRunner("stringEchoService").withPayload((Object)new A("Hello"))).run();
        Message response = muleEvent.getMessage();
        Assert.assertTrue((boolean)(response.getPayload().getValue() instanceof C));
        Assert.assertEquals((Object)"HelloAFromB", (Object)((C)response.getPayload().getValue()).value);
    }

    public static class BtoCConverter
    extends AbstractTransformer
    implements DiscoverableTransformer {
        public BtoCConverter() {
            this.registerSourceType(DataType.fromType(B.class));
            this.setReturnDataType(DataType.fromType(C.class));
        }

        protected Object doTransform(Object src, Charset enc) throws TransformerException {
            return new C(((B)src).value + "FromB");
        }

        public int getPriorityWeighting() {
            return 10;
        }

        public void setPriorityWeighting(int weighting) {
        }
    }

    public static class AtoBConverter
    extends AbstractTransformer
    implements DiscoverableTransformer {
        public AtoBConverter() {
            this.registerSourceType(DataType.fromType(A.class));
            this.setReturnDataType(DataType.fromType(B.class));
        }

        protected Object doTransform(Object src, Charset enc) throws TransformerException {
            return new B(((A)src).value + "A");
        }

        public int getPriorityWeighting() {
            return 10;
        }

        public void setPriorityWeighting(int weighting) {
        }
    }

    public static class C {
        private final String value;

        public C(String value) {
            this.value = value;
        }
    }

    public static class B {
        private final String value;

        public B(String value) {
            this.value = value;
        }
    }

    public static class A {
        private final String value;

        public A(String value) {
            this.value = value;
        }
    }
}

