/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.usecases.sync;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.service.http.TestHttpClient;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.test.AbstractIntegrationTestCase;

public class HttpTransformTestCase
extends AbstractIntegrationTestCase {
    @Rule
    public DynamicPort httpPort2 = new DynamicPort("port2");
    @Rule
    public TestHttpClient httpClient = new TestHttpClient.Builder((HttpService)this.getService(HttpService.class)).build();

    protected String getConfigFile() {
        return "org/mule/test/usecases/sync/http-transform-flow.xml";
    }

    @Test
    public void testBinary() throws Exception {
        ArrayList<Integer> payload = new ArrayList<Integer>();
        payload.add(42);
        HttpRequest httpRequest = ((HttpRequestBuilder)HttpRequest.builder().uri(String.format("http://localhost:%d/RemoteService", this.httpPort2.getNumber())).entity((HttpEntity)new ByteArrayHttpEntity(muleContext.getObjectSerializer().getExternalProtocol().serialize(payload)))).method(HttpConstants.Method.POST).build();
        HttpResponse httpResponse = this.httpClient.send(httpRequest, 5000, false, null);
        Object result = muleContext.getObjectSerializer().getExternalProtocol().deserialize(httpResponse.getEntity().getContent());
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.is(payload));
    }

    @Test
    public void testBinaryWithBridge() throws Exception {
        List<Integer> payload = Arrays.asList(42);
        Message message = ((FlowRunner)this.flowRunner("LocalService").withPayload(payload)).run().getMessage();
        Assert.assertNotNull((Object)message);
        Assert.assertThat((Object)message.getPayload().getValue(), (Matcher)CoreMatchers.equalTo(payload));
    }
}

