/*
 * Decompiled with CFR 0.152.
 */
package org.mule.issues;

import org.junit.Assert;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.message.Message;
import org.mule.test.AbstractIntegrationTestCase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManySendsMule1758TestCase
extends AbstractIntegrationTestCase {
    private static final Logger LOGGER = LoggerFactory.getLogger(ManySendsMule1758TestCase.class);
    private static int NUM_MESSAGES = 3000;

    protected String getConfigFile() {
        return "org/mule/issues/many-sends-mule-1758-test-flow.xml";
    }

    @Test
    public void testSingleSend() throws Exception {
        Message response = ((FlowRunner)this.flowRunner("mySynchService").withPayload((Object)"Marco")).run().getMessage();
        Assert.assertNotNull((String)"Response is null", (Object)response);
        Assert.assertEquals((Object)"Polo", (Object)response.getPayload().getValue());
    }

    @Test
    public void testManySends() throws Exception {
        long then = System.currentTimeMillis();
        for (int i = 0; i < NUM_MESSAGES; ++i) {
            LOGGER.debug("Message " + i);
            Message response = ((FlowRunner)this.flowRunner("mySynchService").withPayload((Object)"Marco")).run().getMessage();
            Assert.assertNotNull((String)"Response is null", (Object)response);
            Assert.assertEquals((Object)"Polo", (Object)response.getPayload().getValue());
        }
        long now = System.currentTimeMillis();
        LOGGER.info("Total time " + (double)(now - then) / 1000.0 + "s; per message " + (double)(now - then) / (1.0 * (double)NUM_MESSAGES) + "ms");
    }
}

