/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.test.integration.lifecycle;

import io.qameta.allure.Issue;
import java.io.InputStream;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.mule.functional.junit4.ApplicationContextBuilder;
import org.mule.functional.junit4.DomainContextBuilder;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.service.http.TestHttpClient;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;

@Ignore(value="MULE-10633")
@Issue(value="MULE-10633")
public class AppAndDomainLifecycleTestCase
extends AbstractMuleTestCase {
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");
    @Rule
    public SystemProperty endpointScheme = this.getEndpointSchemeSystemProperty();
    @Rule
    public TestHttpClient httpClient = new TestHttpClient.Builder().build();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void appShutdownDoesNotStopsDomainConnector() throws Exception {
        MuleContext domainContext = null;
        MuleContext firstAppContext = null;
        MuleContext secondAppContext = null;
        try {
            domainContext = new DomainContextBuilder().setDomainConfig(new String[]{"lifecycle/domain/http/http-shared-listener-config.xml"}).build();
            firstAppContext = new ApplicationContextBuilder().setApplicationResources(new String[]{"lifecycle/domain/http/http-hello-mule-app.xml"}).setDomainContext(domainContext).build();
            ApplicationContextBuilder secondApp = new ApplicationContextBuilder();
            secondAppContext = secondApp.setApplicationResources(new String[]{"lifecycle/domain/http/http-hello-world-app.xml"}).setDomainContext(domainContext).build();
            firstAppContext.stop();
            HttpRequest request = ((HttpRequestBuilder)HttpRequest.builder().uri("http://localhost:" + this.dynamicPort.getNumber() + "/service/helloWorld").method(HttpConstants.Method.GET).entity((HttpEntity)new ByteArrayHttpEntity("test".getBytes()))).build();
            HttpResponse response = this.httpClient.send(request, 60, false, null);
            Assert.assertThat((Object)response, (Matcher)IsNull.notNullValue());
            Assert.assertThat((Object)IOUtils.toString((InputStream)response.getEntity().getContent()), (Matcher)Is.is((Object)"hello world"));
            this.closeQuietly(domainContext);
            this.closeQuietly(firstAppContext);
            this.closeQuietly(secondAppContext);
        }
        catch (Throwable throwable) {
            this.closeQuietly(domainContext);
            this.closeQuietly(firstAppContext);
            this.closeQuietly(secondAppContext);
            throw throwable;
        }
    }

    private void closeQuietly(MuleContext context) {
        if (context != null) {
            try {
                context.dispose();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public SystemProperty getEndpointSchemeSystemProperty() {
        return new SystemProperty("scheme", "http");
    }
}

