/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.test.integration.lifecycle;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Answers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.functional.api.component.LifecycleObject;
import org.mule.functional.junit4.ApplicationContextBuilder;
import org.mule.runtime.api.el.DefaultExpressionLanguageFactoryService;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.lifecycle.LifecycleException;
import org.mule.runtime.core.api.config.ConfigurationBuilder;
import org.mule.runtime.core.api.config.builders.SimpleConfigurationBuilder;
import org.mule.runtime.http.api.HttpService;
import org.mule.tck.SimpleUnitTestSupportSchedulerService;
import org.mule.tck.junit4.AbstractMuleTestCase;

@Feature(value="Lifecycle and Dependency Injection")
@Story(value="Lifecycle Phase Failure")
public class MuleContextLifecycleTestCase
extends AbstractMuleTestCase {
    private static final String EXPECTED_A_CONTEXT_START_EXCEPTION_EXCEPTION = "Expected a ContextStartException exception";
    private SimpleUnitTestSupportSchedulerService schedulerService;

    @Before
    public void before() {
        this.schedulerService = new SimpleUnitTestSupportSchedulerService();
    }

    @After
    public void after() throws Exception {
        if (this.schedulerService != null) {
            this.schedulerService.stop();
        }
    }

    @Test
    @Ignore(value="MULE-15693")
    public void failOnStartInvokesStopInOtherComponentsButNotInTheFailedOne() {
        this.testOnContextLifecycleFailure("lifecycle/component-failing-during-startup-config.xml", failOnStartLifecycleBean -> {
            LifecycleObject lifecycleBean = failOnStartLifecycleBean.getOtherLifecycleObject();
            Assert.assertThat((Object)lifecycleBean.getLifecycleInvocations(), (Matcher)Matchers.hasSize((int)2));
            Assert.assertThat((Object)failOnStartLifecycleBean.getLifecycleInvocations(), (Matcher)Matchers.hasSize((int)2));
        });
    }

    @Test
    public void failOnInitialiseInvokesDisposeInOtherComponentsButNotInTheFailedOne() {
        this.testOnContextLifecycleFailure("lifecycle/component-failing-during-initialise-config.xml", failOnStartLifecycleBean -> {
            LifecycleObject lifecycleBean = failOnStartLifecycleBean.getOtherLifecycleObject();
            Assert.assertThat((Object)lifecycleBean.getLifecycleInvocations(), (Matcher)Matchers.hasSize((int)2));
            Assert.assertThat((Object)lifecycleBean.getLifecycleInvocations(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"initialise", "dispose"}));
            Assert.assertThat((Object)failOnStartLifecycleBean.getLifecycleInvocations(), (Matcher)Matchers.hasSize((int)1));
            Assert.assertThat(failOnStartLifecycleBean.getLifecycleInvocations().get(0), (Matcher)Matchers.equalTo((Object)"initialise"));
        });
    }

    private void testOnContextLifecycleFailure(String configFile, Consumer<LifecycleObject> failureLifecycleBeanConsumer) {
        try {
            new ApplicationContextBuilder(){

                protected final void addBuilders(List<ConfigurationBuilder> builders) {
                    HashMap<String, Object> baseRegistry = new HashMap<String, Object>();
                    baseRegistry.put("httpService", Mockito.mock(HttpService.class, (Answer)Answers.RETURNS_DEEP_STUBS.get()));
                    baseRegistry.put("schedulerService", MuleContextLifecycleTestCase.this.schedulerService);
                    baseRegistry.put("elService", new DefaultExpressionLanguageFactoryService(){

                        public ExpressionLanguage create() {
                            return (ExpressionLanguage)Mockito.mock(ExpressionLanguage.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
                        }

                        public String getName() {
                            return "test-el";
                        }
                    });
                    builders.add((ConfigurationBuilder)new SimpleConfigurationBuilder(baseRegistry));
                }
            }.setApplicationResources(new String[]{configFile}).setContextId(MuleContextLifecycleTestCase.class.getSimpleName()).build();
            Assert.fail((String)EXPECTED_A_CONTEXT_START_EXCEPTION_EXCEPTION);
        }
        catch (LifecycleException e) {
            LifecycleObject lifecycleBean = (LifecycleObject)e.getComponent();
            failureLifecycleBeanConsumer.accept(lifecycleBean);
        }
        catch (Exception e) {
            Assert.fail((String)String.format("Expected a %s exception", LifecycleException.class.getName()));
        }
    }
}

