/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.test.integration.properties;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mule.functional.junit4.ApplicationContextBuilder;
import org.mule.functional.junit4.DomainContextBuilder;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.internal.registry.DefaultRegistry;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class DomainPropertiesPlaceHolderPropagationTestCase
extends AbstractMuleTestCase {
    private MuleContext domainContext;
    private MuleContext applicationContext;

    @Test
    public void propertiesPropagatesToAppUsingContext() throws Exception {
        this.configureContexts("properties/domain/shared-context-properties.xml", "properties/domain/app-with-no-properties.xml");
        this.propertiesPropagatesScenario();
    }

    @Test
    public void appPropertiesPrecedeDomainPropertiesUsingContext() throws Exception {
        this.configureContexts("properties/domain/shared-context-properties.xml", "properties/domain/app-with-context-properties.xml");
        this.appPropertiesPrecedeDomainPropertiesScenario();
    }

    private void appPropertiesPrecedeDomainPropertiesScenario() {
        String domainPropertyObject = this.getDomainProperty("domainPropertyObject");
        Assert.assertThat((Object)domainPropertyObject, (Matcher)Is.is((Object)"9999"));
        String appPropertyObject = this.getApplicationProperty("appPropertyObject");
        Assert.assertThat((Object)appPropertyObject, (Matcher)Is.is((Object)"10000"));
        String app2PropertyObject = this.getApplicationProperty("app2PropertyObject");
        Assert.assertThat((Object)app2PropertyObject, (Matcher)Is.is((Object)"service"));
    }

    private void propertiesPropagatesScenario() {
        String domainPropertyObject = this.getDomainProperty("domainPropertyObject");
        Assert.assertThat((Object)domainPropertyObject, (Matcher)Is.is((Object)"9999"));
        String appPropertyObject = this.getApplicationProperty("appPropertyObject");
        Assert.assertThat((Object)appPropertyObject, (Matcher)Is.is((Object)"9999"));
        String inlinePropertyObject = this.getApplicationProperty("inlinePropertyObject");
        Assert.assertThat((Object)inlinePropertyObject, (Matcher)Is.is((Object)("file contents" + System.lineSeparator())));
    }

    private String getApplicationProperty(String property) {
        return (String)((ConfigurationProperties)new DefaultRegistry(this.applicationContext).lookupByType(ConfigurationProperties.class).get()).resolveStringProperty(property).get();
    }

    private String getDomainProperty(String property) {
        return (String)((ConfigurationProperties)new DefaultRegistry(this.domainContext).lookupByType(ConfigurationProperties.class).get()).resolveStringProperty(property).get();
    }

    private void configureContexts(String domainConfig, String appConfig) throws Exception {
        this.domainContext = new DomainContextBuilder().setContextId(DomainPropertiesPlaceHolderPropagationTestCase.class.getSimpleName()).setDomainConfig(new String[]{domainConfig}).build();
        this.applicationContext = new ApplicationContextBuilder().setContextId(DomainPropertiesPlaceHolderPropagationTestCase.class.getSimpleName()).setApplicationResources(new String[]{appConfig}).setDomainContext(this.domainContext).build();
    }

    @After
    public void after() {
        if (this.applicationContext != null) {
            this.applicationContext.dispose();
        }
        if (this.domainContext != null) {
            this.domainContext.dispose();
        }
    }
}

