/*
 * Decompiled with CFR 0.152.
 */
package org.mule.shutdown;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.service.http.TestHttpClient;
import org.mule.shutdown.AbstractShutdownTimeoutRequestResponseTestCase;
import org.mule.tck.junit4.rule.SystemProperty;

public class ExpiredShutdownTimeoutRequestResponseTestCase
extends AbstractShutdownTimeoutRequestResponseTestCase {
    @Rule
    public SystemProperty contextShutdownTimeout = new SystemProperty("contextShutdownTimeout", "100");
    @Rule
    public TestHttpClient httpClient = new TestHttpClient.Builder((HttpService)this.getService(HttpService.class)).build();

    protected String getConfigFile() {
        return "shutdown-timeout-request-response-config.xml";
    }

    @Test
    public void testScriptComponent() throws Exception {
        this.doShutDownTest("http://localhost:" + this.httpPort.getNumber() + "/scriptComponent");
    }

    @Test
    public void testExpressionTransformer() throws Exception {
        this.doShutDownTest("http://localhost:" + this.httpPort.getNumber() + "/expressionTransformer");
    }

    private void doShutDownTest(String url) throws MuleException, InterruptedException {
        boolean[] results = new boolean[]{false};
        Thread t = new Thread(() -> {
            try {
                HttpRequest request = ((HttpRequestBuilder)HttpRequest.builder().uri(url).entity((HttpEntity)new ByteArrayHttpEntity("Test Message".getBytes()))).method(HttpConstants.Method.POST).build();
                HttpResponse response = this.httpClient.send(request, 5000, false, null);
                results[0] = response.getStatusCode() != HttpConstants.HttpStatus.OK.getStatusCode();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        t.start();
        waitLatch.await();
        muleContext.stop();
        t.join();
        Assert.assertTrue((String)"Was able to process message ", (boolean)results[0]);
    }
}

