/*
 * Decompiled with CFR 0.152.
 */
package org.mule.shutdown;

import java.io.InputStream;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.service.http.TestHttpClient;
import org.mule.shutdown.AbstractShutdownTimeoutRequestResponseTestCase;
import org.mule.tck.junit4.rule.SystemProperty;

public class ValidShutdownTimeoutRequestResponseTestCase
extends AbstractShutdownTimeoutRequestResponseTestCase {
    @Rule
    public SystemProperty contextShutdownTimeout = new SystemProperty("contextShutdownTimeout", "5000");
    @Rule
    public TestHttpClient httpClient = new TestHttpClient.Builder((HttpService)this.getService(HttpService.class)).build();

    @After
    public void disposeHttpClient() {
        this.httpClient.stop();
    }

    protected boolean isGracefulShutdown() {
        return true;
    }

    protected String getConfigFile() {
        return "shutdown-timeout-request-response-config.xml";
    }

    @Test
    public void testScriptComponent() throws Exception {
        this.doShutDownTest("scriptComponentResponse", "http://localhost:" + this.httpPort.getNumber() + "/scriptComponent");
    }

    @Test
    public void testExpressionTransformer() throws Exception {
        this.doShutDownTest("expressionTransformerResponse", "http://localhost:" + this.httpPort.getNumber() + "/expressionTransformer");
    }

    private void doShutDownTest(String payload, String url) throws MuleException, InterruptedException {
        boolean[] results = new boolean[]{false};
        Thread t = new Thread(() -> {
            try {
                HttpRequest request = ((HttpRequestBuilder)HttpRequest.builder().uri(url).method(HttpConstants.Method.GET).entity((HttpEntity)new ByteArrayHttpEntity(payload.getBytes()))).build();
                HttpResponse response = this.httpClient.send(request, 5000, false, null);
                results[0] = payload.equals(IOUtils.toString((InputStream)response.getEntity().getContent()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        t.start();
        waitLatch.await();
        muleContext.stop();
        t.join();
        Assert.assertTrue((String)"Was not able to process message ", (boolean)results[0]);
    }
}

