/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.components;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Matchers;
import org.mule.functional.junit4.ApplicationContextBuilder;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.junit4.AbstractMuleTestCase;

@Feature(value="Configuration properties")
@Story(value="Component configuration properties error scenarios")
public class ConfigurationPropertiesErrorScenariosTestCase
extends AbstractMuleTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Description(value="Validates the exception message when the configuration-properties element is pointing to a non existent file")
    @Test
    public void nonExistentFile() throws Exception {
        this.expectedException.expectMessage(Matchers.contains((String)"Couldn't find configuration properties file non-existent.properties neither on classpath or in file system"));
        new ApplicationContextBuilder().setApplicationResources(new String[]{"org/mule/test/components/non-existent-configuration-properties-file.xml"}).build();
    }

    @Description(value="Validates the exception message when the configuration-properties element is pointing to a non existent file defined with a system property")
    @Test
    public void nonExistentFileDefinedWithSystemProperty() throws Exception {
        MuleTestUtils.testWithSystemProperty((String)"env", (String)"no-env", () -> {
            this.expectedException.expectMessage("Couldn't find configuration properties file no-env.properties neither on classpath or in file system");
            new ApplicationContextBuilder().setApplicationResources(new String[]{"org/mule/test/components/customizable-configuration-properties-file.xml"}).build();
        });
    }

    @Description(value="Validates the exception message when the configuration-properties element points has a file attribute with a placeholder that could not be resolved")
    @Test
    public void fileReferenceWithNoValuePlaceholder() throws Exception {
        this.expectedException.expectMessage(Matchers.contains((String)"Couldn't find configuration property value for key ${env} from properties provider system properties provider"));
        new ApplicationContextBuilder().setApplicationResources(new String[]{"org/mule/test/components/customizable-configuration-properties-file.xml"}).build();
    }
}

