/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.config;

import javax.xml.namespace.QName;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.util.ComponentLocationProvider;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.test.AbstractIntegrationTestCase;

public class ConfigurationAnnotationsTestCase
extends AbstractIntegrationTestCase {
    protected String[] getConfigFiles() {
        return new String[]{"org/mule/config/spring/annotations.xml", "org/mule/config/spring/annotations-config.xml"};
    }

    @Test
    public void testTransformerAnnotations() {
        Transformer stb = (Transformer)this.registry.lookupByName("StringtoByteArray").get();
        Assert.assertThat((Object)stb, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)this.getDocName(stb), (Matcher)CoreMatchers.is((Object)"stb-transformer"));
        Assert.assertThat((Object)this.getDocDescription(stb), (Matcher)CoreMatchers.is((Object)"Convert a String to a Byte Array"));
        Assert.assertThat((Object)ComponentLocationProvider.getSourceCode((Component)((Component)stb)), (Matcher)CoreMatchers.is((Object)("<string-to-byte-array-transformer name=\"StringtoByteArray\" doc:name=\"stb-transformer\">" + System.lineSeparator() + "<annotations>" + System.lineSeparator() + "<doc:description>Convert a String to a Byte Array</doc:description>" + System.lineSeparator() + "</annotations>" + System.lineSeparator() + "</string-to-byte-array-transformer>")));
    }

    @Test
    public void testFlowAnnotations() {
        FlowConstruct flow = (FlowConstruct)this.registry.lookupByName("Bridge").get();
        Assert.assertThat((Object)flow, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)this.getDocName(flow), (Matcher)CoreMatchers.is((Object)"Bridge flow"));
        Assert.assertThat((Object)this.getDocDescription(flow), (Matcher)CoreMatchers.is((Object)"Main flow"));
        Assert.assertThat((Object)ComponentLocationProvider.getSourceCode((Component)flow), (Matcher)CoreMatchers.is((Object)("<flow name=\"Bridge\" doc:name=\"Bridge flow\">" + System.lineSeparator() + "<annotations>" + System.lineSeparator() + "<doc:description>Main flow</doc:description>" + System.lineSeparator() + "</annotations>" + System.lineSeparator() + "<logger doc:name=\"echo\"></logger>" + System.lineSeparator() + "</flow>")));
    }

    @Test
    public void testFlowWithExceptionStrategyAnnotations() {
        FlowConstruct flow = (FlowConstruct)this.registry.lookupByName("WithRefExceptionStrategy").get();
        Assert.assertThat((Object)flow, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)this.getDocName(flow), (Matcher)CoreMatchers.is((Object)"With Referenced Exception Strategy"));
        Assert.assertThat((Object)this.getDocDescription(flow), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)ComponentLocationProvider.getSourceCode((Component)flow), (Matcher)CoreMatchers.is((Object)("<flow name=\"WithRefExceptionStrategy\" doc:name=\"With Referenced Exception Strategy\">" + System.lineSeparator() + "<logger doc:name=\"echo_ex\"></logger>" + System.lineSeparator() + "<error-handler doc:name=\"error handler doc name\">" + System.lineSeparator() + "<on-error-continue doc:name=\"On Error Continue\">" + System.lineSeparator() + "<logger message=\"Exception! \" level=\"ERROR\" doc:name=\"Logger\"></logger>" + System.lineSeparator() + "</on-error-continue>" + System.lineSeparator() + "</error-handler>" + System.lineSeparator() + "</flow>")));
    }

    @Test
    public void testDefaultAnnotationsInNotAnnotatedObject() {
        FlowConstruct flow = (FlowConstruct)this.registry.lookupByName("NotAnnotatedBridge").get();
        Assert.assertThat((Object)flow, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)this.getDocName(flow), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)this.getDocDescription(flow), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)ComponentLocationProvider.getSourceCode((Component)flow), (Matcher)CoreMatchers.is((Object)("<flow name=\"NotAnnotatedBridge\">" + System.lineSeparator() + "<logger></logger>" + System.lineSeparator() + "</flow>")));
    }

    @Test
    public void testJavaComponentAnnotations() {
        Flow flow = (Flow)this.registry.lookupByName("Bridge").get();
        Processor logger = (Processor)flow.getProcessors().get(0);
        Assert.assertThat((Object)ComponentLocationProvider.getSourceCode((Component)((Component)logger)), (Matcher)CoreMatchers.is((Object)"<logger doc:name=\"echo\"></logger>"));
    }

    @Test
    public void testInsideSpringBeansAnnotations() {
        Transformer stb = (Transformer)this.registry.lookupByName("ManziTransformer").get();
        Assert.assertThat((Object)stb, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)this.getDocName(stb), (Matcher)CoreMatchers.is((Object)"manzi-transformer"));
        Assert.assertThat((Object)ComponentLocationProvider.getSourceCode((Component)((Component)stb)), (Matcher)CoreMatchers.is((Object)"<append-string-transformer message=\"Manzi\" name=\"ManziTransformer\" doc:name=\"manzi-transformer\"></append-string-transformer>"));
    }

    protected String getDocName(Object obj) {
        return (String)((Component)obj).getAnnotation(new QName("http://www.mulesoft.org/schema/mule/documentation", "name"));
    }

    protected String getDocDescription(Object obj) {
        return (String)((Component)obj).getAnnotation(new QName("http://www.mulesoft.org/schema/mule/documentation", "description"));
    }
}

