/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.config.spring;

import java.util.List;
import javax.inject.Inject;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.runtime.api.config.custom.ServiceConfigurator;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreManager;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationBuilder;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.test.runner.RunnerDelegateTo;

@RunnerDelegateTo(value=MockitoJUnitRunner.class)
public class InjectPrimaryObjectStoreManagerTestCase
extends AbstractIntegrationTestCase {
    @Mock
    private ObjectStore overridenBaseStore;

    protected String[] getConfigFiles() {
        return new String[0];
    }

    protected void addBuilders(List<ConfigurationBuilder> builders) {
        builders.add(new ConfigurationBuilder(){

            public void configure(MuleContext muleContext) throws ConfigurationException {
                muleContext.getCustomizationService().overrideDefaultServiceImpl("_defaultInMemoryObjectStore", (Object)InjectPrimaryObjectStoreManagerTestCase.this.overridenBaseStore);
                muleContext.getCustomizationService().overrideDefaultServiceImpl("_defaultPersistentObjectStore", (Object)InjectPrimaryObjectStoreManagerTestCase.this.overridenBaseStore);
            }

            public void addServiceConfigurator(ServiceConfigurator serviceConfigurator) {
            }
        });
    }

    @Test
    public void twoManagersRegistered() {
        Assert.assertThat((Object)this.registry.lookupAllByType(ObjectStoreManager.class), (Matcher)Matchers.hasSize((int)2));
    }

    @Test
    public void injectPrimaryObjectStoreManager() throws Exception {
        InjectionTarget target = new InjectionTarget();
        muleContext.getInjector().inject((Object)target);
        Assert.assertThat((Object)target.getObjectStoreManager(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    public static class InjectionTarget {
        @Inject
        private ObjectStoreManager objectStoreManager;

        public ObjectStoreManager getObjectStoreManager() {
            return this.objectStoreManager;
        }
    }
}

