/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.config.spring.parsers;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Test;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.test.IntegrationTestCaseRunnerConfig;
import org.mule.tests.parsers.api.ParameterAndChildElement;
import org.mule.tests.parsers.api.ParsersTestObject;
import org.mule.tests.parsers.api.PojoWithSameTypeChildren;
import org.mule.tests.parsers.api.SimplePojo;

public class XmlDslProcessingTestCase
extends AbstractIntegrationTestCase
implements IntegrationTestCaseRunnerConfig {
    private static final String FIRST_NAME_ATTRIBUTE = "firstname";
    private static final String LAST_NAME_ATTRIBUTE = "lastname";
    private static final String AGE_ATTRIBUTE = "age";

    protected String getConfigFile() {
        return "org/mule/config/spring/parsers/xml-dsl-processing-config.xml";
    }

    @Test
    public void onlySimpleParametersInSingleAttribute() {
        ParsersTestObject parsersTestObject = (ParsersTestObject)this.registry.lookupByName("onlySimpleParametersObject").get();
        Map simpleParameters = parsersTestObject.getSimpleParameters();
        Assert.assertThat((Object)simpleParameters.size(), (Matcher)Is.is((Object)3));
        this.assertPabloChildParameters(simpleParameters);
    }

    @Test
    public void firstComplexChildUsingWrapper() {
        ParsersTestObject parsersTestObject = (ParsersTestObject)this.registry.lookupByName("onlyComplexFirstChildParameterObject").get();
        Map simpleParameters = parsersTestObject.getSimpleParameters();
        Assert.assertThat((Object)simpleParameters.size(), (Matcher)Is.is((Object)1));
        this.assertPabloChildParameters(((ParsersTestObject)simpleParameters.get("first-child")).getSimpleParameters());
    }

    @Test
    public void secondComplexChildUsingWrapper() {
        ParsersTestObject parsersTestObject = (ParsersTestObject)this.registry.lookupByName("onlyComplexSecondChildParameterObject").get();
        Map simpleParameters = parsersTestObject.getSimpleParameters();
        Assert.assertThat((Object)simpleParameters.size(), (Matcher)Is.is((Object)1));
        this.assertMarianoChildParameters(((ParsersTestObject)simpleParameters.get("second-child")).getSimpleParameters());
    }

    @Test
    public void complexChildrenListUsingWrapper() {
        ParsersTestObject parsersTestObject = (ParsersTestObject)this.registry.lookupByName("onlyComplexChildrenListParameterObject").get();
        Map simpleParameters = parsersTestObject.getSimpleParameters();
        Assert.assertThat((Object)simpleParameters.size(), (Matcher)Is.is((Object)1));
        this.assertCollectionChildrenContent((List)simpleParameters.get("other-children"));
    }

    @Test
    public void completeParametersObject() {
        ParsersTestObject parsersTestObject = (ParsersTestObject)this.registry.lookupByName("completeParametersObject").get();
        Map simpleParameters = parsersTestObject.getSimpleParameters();
        Assert.assertThat((Object)simpleParameters.size(), (Matcher)Is.is((Object)6));
        this.assertPabloChildParameters(simpleParameters);
        this.assertPabloChildParameters(((ParsersTestObject)simpleParameters.get("first-child")).getSimpleParameters());
        this.assertMarianoChildParameters(((ParsersTestObject)simpleParameters.get("second-child")).getSimpleParameters());
        this.assertCollectionChildrenContent((List)simpleParameters.get("other-children"));
    }

    @Test
    public void customCollectionTypeObject() {
        ParsersTestObject parsersTestObject = (ParsersTestObject)this.registry.lookupByName("customCollectionTypeObject").get();
        Map simpleParameters = parsersTestObject.getSimpleParameters();
        Assert.assertThat((Object)simpleParameters.size(), (Matcher)Is.is((Object)1));
        List collectionObject = (List)simpleParameters.get("other-children-custom-collection-type");
        Assert.assertThat((Object)collectionObject, (Matcher)IsInstanceOf.instanceOf(LinkedList.class));
        this.assertCollectionChildrenContent(collectionObject);
    }

    @Test
    public void simpleTypeObject() {
        ParsersTestObject parsersTestObject = (ParsersTestObject)this.registry.lookupByName("simpleTypeObject").get();
        this.assertSimpleTypeCollectionValues(parsersTestObject.getSimpleTypeList());
        Assert.assertThat((Object)parsersTestObject.getSimpleTypeSet(), (Matcher)IsInstanceOf.instanceOf(TreeSet.class));
        this.assertSimpleTypeCollectionValues(parsersTestObject.getSimpleTypeSet());
        Map simpleParameters = parsersTestObject.getSimpleParameters();
        Assert.assertThat((Object)simpleParameters.size(), (Matcher)Is.is((Object)1));
        this.assertSimpleTypeCollectionValues((List)simpleParameters.get("other-simple-type-child-list-custom-key"));
    }

    @Test
    public void simpleTypeChildListWithConverter() {
        ParsersTestObject parsersTestObject = (ParsersTestObject)this.registry.lookupByName("simpleTypeObjectWithConverter").get();
        List simpleTypeListWithConverter = parsersTestObject.getSimpleTypeListWithConverter();
        Assert.assertThat((Object)simpleTypeListWithConverter.size(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)simpleTypeListWithConverter, (Matcher)Matchers.hasItems((Object[])new String[]{"value1-with-converter", "value2-with-converter"}));
    }

    @Test
    public void simpleTypeMapObject() {
        ParsersTestObject parsersTestObject = (ParsersTestObject)this.registry.lookupByName("simpleTypeMapObject").get();
        Map simpleTypeMap = parsersTestObject.getSimpleTypeMap();
        Assert.assertThat((Object)simpleTypeMap.size(), (Matcher)Is.is((Object)2));
    }

    @Test
    public void simpleListTypeMapObject() {
        ParsersTestObject parsersTestObject = (ParsersTestObject)this.registry.lookupByName("simpleTypeCollectionMapObject").get();
        Map simpleListTypeMap = parsersTestObject.getSimpleListTypeMap();
        Assert.assertThat((Object)simpleListTypeMap.size(), (Matcher)Is.is((Object)2));
        List firstCollection = (List)simpleListTypeMap.get("1");
        Assert.assertThat((Object)firstCollection, (Matcher)Matchers.hasItems((Object[])new String[]{"value1", "value2"}));
        List secondCollection = (List)simpleListTypeMap.get("2");
        Assert.assertThat((Object)secondCollection, (Matcher)Matchers.hasItem((Object)"#[mel:'some expression']"));
    }

    @Test
    public void complexTypeMapObject() {
        ParsersTestObject parsersTestObject = (ParsersTestObject)this.registry.lookupByName("complexTypeMapObject").get();
        Map simpleTypeMap = parsersTestObject.getComplexTypeMap();
        Assert.assertThat((Object)simpleTypeMap.size(), (Matcher)Is.is((Object)2));
        this.assertPabloChildParameters(((ParsersTestObject)simpleTypeMap.get(1L)).getSimpleParameters());
        this.assertMarianoChildParameters(((ParsersTestObject)simpleTypeMap.get(2L)).getSimpleParameters());
    }

    @Test
    public void pojoWithDefaultValue() {
        ParameterAndChildElement parameterAndChildElement = (ParameterAndChildElement)this.registry.lookupByName("pojoWithDefaultValue").get();
        Assert.assertThat((Object)parameterAndChildElement.getSimplePojo().equals((Object)new SimplePojo("jose")), (Matcher)Is.is((Object)true));
    }

    @Test
    public void pojoFromConfiguraitonParameter() {
        ParameterAndChildElement parameterAndChildElement = (ParameterAndChildElement)this.registry.lookupByName("pojoWithAttribute").get();
        Assert.assertThat((Object)parameterAndChildElement.getSimplePojo().equals((Object)new SimplePojo("pepe")), (Matcher)Is.is((Object)true));
    }

    @Test
    public void pojoFromChildConfiguration() {
        ParameterAndChildElement parameterAndChildElement = (ParameterAndChildElement)this.registry.lookupByName("pojoWithChild").get();
        Assert.assertThat((Object)parameterAndChildElement.getSimplePojo().equals((Object)new SimplePojo("pepe")), (Matcher)Is.is((Object)true));
    }

    @Test
    public void objectWithTwoChildrenOfSameTypeWithoutWrapper() {
        PojoWithSameTypeChildren pojoWithSameTypeChildren = (PojoWithSameTypeChildren)this.registry.lookupByName("sameChildTypesObject").get();
        this.assertPabloChildParameters(pojoWithSameTypeChildren.getElementTypeA().getSimpleParameters());
        this.assertMarianoChildParameters(pojoWithSameTypeChildren.getAnotherElementTypeA().getSimpleParameters());
    }

    @Test
    public void textPojo() {
        SimplePojo pojo = (SimplePojo)this.registry.lookupByName("textPojo").get();
        Assert.assertThat((Object)pojo, (Matcher)Is.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)pojo.getSomeParameter(), (Matcher)Is.is((Object)"select * from PLANET"));
    }

    @Test
    public void simpleTypeWithConverterObject() {
        ParsersTestObject parsersTestObject = (ParsersTestObject)this.registry.lookupByName("simpleTypeWithConverterObject").get();
        Assert.assertThat((Object)parsersTestObject.getSimpleTypeWithConverter(), (Matcher)Is.is((Object)new SimplePojo("5")));
    }

    private void assertSimpleTypeCollectionValues(Collection<String> simpleTypeCollectionValues) {
        Assert.assertThat((Object)simpleTypeCollectionValues.size(), (Matcher)Is.is((Object)2));
        Assert.assertThat(simpleTypeCollectionValues, (Matcher)Matchers.hasItems((Object[])new String[]{"value1", "value2"}));
    }

    private void assertCollectionChildrenContent(List<ParsersTestObject> collectionObjects) {
        this.assertPabloChildParameters(collectionObjects.get(0).getSimpleParameters());
        this.assertMarianoChildParameters(collectionObjects.get(1).getSimpleParameters());
    }

    private void assertPabloChildParameters(Map<Object, Object> simpleParameters) {
        Assert.assertThat((Object)simpleParameters.get(FIRST_NAME_ATTRIBUTE), (Matcher)Is.is((Object)"Pablo"));
        Assert.assertThat((Object)simpleParameters.get(LAST_NAME_ATTRIBUTE), (Matcher)Is.is((Object)"La Greca"));
        Assert.assertThat((Object)simpleParameters.get(AGE_ATTRIBUTE), (Matcher)Is.is((Object)"32"));
    }

    private void assertMarianoChildParameters(Map<Object, Object> simpleParameters) {
        Assert.assertThat((Object)simpleParameters.get(FIRST_NAME_ATTRIBUTE), (Matcher)Is.is((Object)"Mariano"));
        Assert.assertThat((Object)simpleParameters.get(LAST_NAME_ATTRIBUTE), (Matcher)Is.is((Object)"Gonzalez"));
        Assert.assertThat((Object)simpleParameters.get(AGE_ATTRIBUTE), (Matcher)Is.is((Object)"31"));
    }
}

