/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.construct;

import com.eaio.uuid.UUID;
import java.io.Serializable;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.functional.api.component.TestConnectorQueueHandler;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.functional.junit4.TestLegacyMessageBuilder;
import org.mule.functional.junit4.TestLegacyMessageUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.test.AbstractIntegrationTestCase;

public class FlowAsyncBeforeAfterOutboundTestCase
extends AbstractIntegrationTestCase {
    private TestConnectorQueueHandler queueHandler;

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.queueHandler = new TestConnectorQueueHandler(this.registry);
    }

    protected String getConfigFile() {
        return "org/mule/test/construct/flow-async-before-after-outbound.xml";
    }

    @Test
    public void testAsyncBefore() throws Exception {
        Message msgSync = ((FlowRunner)this.flowRunner("test-async-block-before-outbound").withPayload((Object)"message")).run().getMessage();
        Message msgAsync = this.queueHandler.read("test.before.async.out", 5000L).getMessage();
        Message msgOut = this.queueHandler.read("test.before.out", 5000L).getMessage();
        this.assertCorrectThreads(msgSync, msgAsync, msgOut);
    }

    @Test
    public void testAsyncAfter() throws Exception {
        Message msgSync = ((FlowRunner)this.flowRunner("test-async-block-after-outbound").withPayload((Object)"message")).run().getMessage();
        Message msgAsync = this.queueHandler.read("test.after.async.out", 5000L).getMessage();
        Message msgOut = this.queueHandler.read("test.after.out", 5000L).getMessage();
        this.assertCorrectThreads(msgSync, msgAsync, msgOut);
    }

    private void assertCorrectThreads(Message msgSync, Message msgAsync, Message msgOut) throws Exception {
        Assert.assertThat((Object)msgSync, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)msgAsync, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)msgOut, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)TestLegacyMessageUtils.getInboundProperty((Message)msgOut, (String)"request-response-thread"), (Matcher)CoreMatchers.equalTo((Object)TestLegacyMessageUtils.getInboundProperty((Message)msgSync, (String)"request-response-thread")));
        Assert.assertThat((Object)TestLegacyMessageUtils.getOutboundProperty((Message)msgSync, (String)"request-response-thread"), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)TestLegacyMessageUtils.getOutboundProperty((Message)msgAsync, (String)"async-thread"))));
        Assert.assertThat((Object)TestLegacyMessageUtils.getOutboundProperty((Message)msgOut, (String)"request-response-thread"), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)TestLegacyMessageUtils.getOutboundProperty((Message)msgAsync, (String)"async-thread"))));
    }

    public static class ThreadSensingMessageProcessor
    implements Processor {
        private static final ThreadLocal<String> taskTokenInThread = new ThreadLocal();

        public CoreEvent process(CoreEvent event) throws MuleException {
            String requestTaskToken;
            if (taskTokenInThread.get() != null) {
                requestTaskToken = taskTokenInThread.get();
            } else {
                requestTaskToken = this.generateTaskToken();
                taskTokenInThread.set(requestTaskToken);
            }
            return CoreEvent.builder((CoreEvent)event).message(new TestLegacyMessageBuilder(event.getMessage()).addOutboundProperty((String)((TypedValue)event.getVariables().get("property-name")).getValue(), (Serializable)((Object)requestTaskToken)).build()).build();
        }

        protected String generateTaskToken() {
            return Thread.currentThread().getName() + " - " + new UUID().toString();
        }
    }
}

