/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.construct;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.functional.api.component.TestConnectorQueueHandler;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.functional.api.flow.TransactionConfigEnum;
import org.mule.functional.junit4.TestLegacyMessageUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.transaction.Transaction;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.runtime.core.api.transaction.TransactionFactory;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.Banana;
import org.mule.tck.testmodels.fruit.Fruit;
import org.mule.tck.testmodels.fruit.FruitBowl;
import org.mule.tck.testmodels.fruit.Orange;
import org.mule.tck.testmodels.mule.TestTransactionFactory;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.test.construct.StringAppendTransformer;

public class FlowConfigurationFunctionalTestCase
extends AbstractIntegrationTestCase {
    private static final String EXPECTED_ARRAY_IN_ARGS_RESULT = "testtestrecieved";
    private TestConnectorQueueHandler queueHandler;

    protected String getConfigFile() {
        return "org/mule/test/construct/flow.xml";
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.queueHandler = new TestConnectorQueueHandler(this.registry);
    }

    @Test
    public void testFlow() throws Exception {
        Flow flow = (Flow)this.registry.lookupByName("flow").get();
        Assert.assertEquals((long)5L, (long)flow.getProcessors().size());
        Assert.assertNotNull((Object)flow.getExceptionListener());
        Assert.assertEquals((Object)"012xyzabc3", (Object)this.getPayloadAsString(((FlowRunner)this.flowRunner("flow").withPayload((Object)"0")).run().getMessage()));
    }

    @Test
    public void testAsyncAsynchronous() throws Exception {
        ((FlowRunner)this.flowRunner("asynchronousAsync").withPayload((Object)"0")).run();
        Message message = this.queueHandler.read("asynchronous-async-out", 5000L).getMessage();
        Assert.assertNotNull((Object)message);
        Thread thread = (Thread)message.getPayload().getValue();
        Assert.assertNotNull((Object)thread);
        Assert.assertNotSame((Object)Thread.currentThread(), (Object)thread);
    }

    @Test
    public void testInOutFlow() throws Exception {
        ((FlowRunner)this.flowRunner("inout").withPayload((Object)"0")).run();
        Assert.assertEquals((Object)"0", (Object)this.getPayloadAsString(this.queueHandler.read("inout-out", 5000L).getMessage()));
    }

    @Test
    public void testInOutAppendFlow() throws Exception {
        ((FlowRunner)this.flowRunner("inout-append").withPayload((Object)"0")).run();
        Assert.assertEquals((Object)"0inout", (Object)this.getPayloadAsString(this.queueHandler.read("inout-append-out", 5000L).getMessage()));
    }

    @Test
    public void testSplitAggregateFlow() throws Exception {
        Apple apple = new Apple();
        Banana banana = new Banana();
        Orange orange = new Orange();
        FruitBowl fruitBowl = new FruitBowl(apple, banana);
        fruitBowl.addFruit((Fruit)orange);
        ((FlowRunner)this.flowRunner("split-aggregate").withPayload((Object)fruitBowl)).run();
        Message result = this.queueHandler.read("split-aggregate-out", 5000L).getMessage();
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result.getPayload().getValue() instanceof List));
        List coll = (List)result.getPayload().getValue();
        Assert.assertEquals((long)3L, (long)coll.size());
        List results = coll.stream().map(msg -> (Fruit)msg.getPayload().getValue()).collect(Collectors.toList());
        Assert.assertTrue((boolean)apple.isBitten());
        Assert.assertTrue((boolean)banana.isBitten());
        Assert.assertTrue((boolean)orange.isBitten());
        Assert.assertTrue((boolean)results.contains(apple));
        Assert.assertTrue((boolean)results.contains(banana));
        Assert.assertTrue((boolean)results.contains(orange));
    }

    @Ignore(value="MULE-12407")
    @Test
    public void testSplitNoParts() throws Exception {
        String MESSAGE = "<Order></Order>";
        Message result = ((FlowRunner)((FlowRunner)this.flowRunner("split-no-parts").withPayload((Object)MESSAGE)).withMediaType(MediaType.APPLICATION_XML)).run().getMessage();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)result.getPayload().getValue(), (Object)MESSAGE);
    }

    @Test
    public void testSplitAggregateListFlow() throws Exception {
        Apple apple = new Apple();
        Banana banana = new Banana();
        Orange orange = new Orange();
        FruitBowl fruitBowl = new FruitBowl(apple, banana);
        fruitBowl.addFruit((Fruit)orange);
        ((FlowRunner)this.flowRunner("split-aggregate-list").withPayload((Object)fruitBowl.getFruit())).run();
        Message result = this.queueHandler.read("split-aggregate-list-out", 5000L).getMessage();
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result.getPayload().getValue() instanceof List));
        List coll = (List)result.getPayload().getValue();
        Assert.assertEquals((long)3L, (long)coll.size());
        List results = coll.stream().map(msg -> (Fruit)msg.getPayload().getValue()).collect(Collectors.toList());
        Assert.assertTrue((boolean)apple.isBitten());
        Assert.assertTrue((boolean)banana.isBitten());
        Assert.assertTrue((boolean)orange.isBitten());
        Assert.assertTrue((boolean)results.contains(apple));
        Assert.assertTrue((boolean)results.contains(banana));
        Assert.assertTrue((boolean)results.contains(orange));
    }

    @Test
    public void testSplitAggregateListFlowSingleItem() throws Exception {
        Apple apple = new Apple();
        FruitBowl fruitBowl = new FruitBowl();
        fruitBowl.addFruit((Fruit)apple);
        ((FlowRunner)this.flowRunner("split-aggregate-singleton-list").withPayload((Object)fruitBowl.getFruit())).run();
        Message result = this.queueHandler.read("split-aggregate-singleton-list-out", 5000L).getMessage();
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result.getPayload().getValue() instanceof List));
        List coll = (List)result.getPayload().getValue();
        Assert.assertEquals((long)1L, (long)coll.size());
        List results = coll.stream().map(msg -> (Fruit)msg.getPayload().getValue()).collect(Collectors.toList());
        Assert.assertTrue((boolean)apple.isBitten());
        Assert.assertTrue((boolean)results.contains(apple));
    }

    @Test
    public void testSplitAggregateResponseListFlow() throws Exception {
        Apple apple = new Apple();
        Banana banana = new Banana();
        Orange orange = new Orange();
        FruitBowl fruitBowl = new FruitBowl(apple, banana);
        fruitBowl.addFruit((Fruit)orange);
        Message result = ((FlowRunner)this.flowRunner("split-aggregate-response-list").withPayload((Object)fruitBowl.getFruit())).run().getMessage();
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result.getPayload().getValue() instanceof List));
        List coll = (List)result.getPayload().getValue();
        Assert.assertEquals((long)3L, (long)coll.size());
        List results = coll.stream().map(msg -> (Fruit)msg.getPayload().getValue()).collect(Collectors.toList());
        Assert.assertTrue((boolean)apple.isBitten());
        Assert.assertTrue((boolean)banana.isBitten());
        Assert.assertTrue((boolean)orange.isBitten());
        Assert.assertTrue((boolean)results.contains(apple));
        Assert.assertTrue((boolean)results.contains(banana));
        Assert.assertTrue((boolean)results.contains(orange));
    }

    @Test
    public void testSplitAggregateResponseListFlowSingleItem() throws Exception {
        Apple apple = new Apple();
        FruitBowl fruitBowl = new FruitBowl();
        fruitBowl.addFruit((Fruit)apple);
        Message result = ((FlowRunner)this.flowRunner("split-aggregate-response-singleton-list").withPayload((Object)fruitBowl.getFruit())).run().getMessage();
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result.getPayload().getValue() instanceof List));
        List coll = (List)result.getPayload().getValue();
        Assert.assertEquals((long)1L, (long)coll.size());
        List results = coll.stream().map(msg -> (Fruit)msg.getPayload().getValue()).collect(Collectors.toList());
        Assert.assertTrue((boolean)apple.isBitten());
        Assert.assertTrue((boolean)results.contains(apple));
    }

    @Test
    public void testSplitAggregateMapFlow() throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Apple apple = new Apple();
        Banana banana = new Banana();
        Orange orange = new Orange();
        map.put("apple", apple);
        map.put("banana", banana);
        map.put("orange", orange);
        CoreEvent result = ((FlowRunner)this.flowRunner("split-aggregate-map").withPayload(map)).run();
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result.getMessage().getPayload().getValue() instanceof List));
        Message[] results = new Message[3];
        ((List)result.getMessage().getPayload().getValue()).toArray(results);
        Assert.assertEquals((long)3L, (long)results.length);
        Assert.assertTrue((boolean)apple.isBitten());
        Assert.assertTrue((boolean)banana.isBitten());
        Assert.assertTrue((boolean)orange.isBitten());
    }

    @Test
    public void testSplitFilterAggregateFlow() throws Exception {
        Apple apple = new Apple();
        Banana banana = new Banana();
        Orange orange = new Orange();
        FruitBowl fruitBowl = new FruitBowl(apple, banana);
        fruitBowl.addFruit((Fruit)orange);
        ((FlowRunner)this.flowRunner("split-filter-aggregate").withPayload((Object)fruitBowl)).run();
        Message result = this.queueHandler.read("split-filter-aggregate-out", 5000L).getMessage();
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result.getPayload().getValue() instanceof List));
        List coll = (List)result.getPayload().getValue();
        Assert.assertEquals((long)1L, (long)coll.size());
        List results = coll.stream().map(msg -> (Fruit)msg.getPayload().getValue()).collect(Collectors.toList());
        Assert.assertTrue((boolean)results.contains(apple));
        Assert.assertFalse((boolean)results.contains(banana));
        Assert.assertFalse((boolean)results.contains(orange));
    }

    @Test
    public void testMessageChunkSplitAggregateFlow() throws Exception {
        String payload = "";
        for (int i = 0; i < 100; ++i) {
            payload = payload + "Test Message";
        }
        ((FlowRunner)this.flowRunner("message-chunk-split-aggregate").withPayload((Object)payload)).run();
        Message result = this.queueHandler.read("message-chunk-split-aggregate-out", 5000L).getMessage();
        Assert.assertNotNull((Object)result);
        Assert.assertNotSame((Object)payload, (Object)result.getPayload().getValue());
        Assert.assertEquals((Object)payload, (Object)this.getPayloadAsString(result));
    }

    @Test
    public void testComponentsFlow() throws Exception {
        Message result = ((FlowRunner)this.flowRunner("components").withPayload((Object)"0")).run().getMessage();
        Assert.assertNotNull((Object)result);
        Assert.assertNotSame((Object)"Test Messagetest", (Object)result.getPayload().getValue());
    }

    @Test
    public void testResponseElement() throws Exception {
        Message result = ((FlowRunner)this.flowRunner("response").withPayload((Object)"")).run().getMessage();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"abcdefghi", (Object)this.getPayloadAsString(result));
    }

    @Test
    public void testAsyncOneWayEndpoint() throws Exception {
        ((FlowRunner)this.flowRunner("async-oneway").withPayload((Object)"0")).run();
        Message result = this.queueHandler.read("async-oneway-out", 5000L).getMessage();
        Message asyncResult = this.queueHandler.read("async-async-oneway-out", 5000L).getMessage();
        Assert.assertNotNull((Object)result);
        Assert.assertNotNull((Object)asyncResult);
        Assert.assertEquals((Object)"0ac", (Object)this.getPayloadAsString(result));
        Assert.assertEquals((Object)"0ab", (Object)this.getPayloadAsString(asyncResult));
    }

    @Test
    public void testAsyncRequestResponseEndpoint() throws Exception {
        CoreEvent syncResult = ((FlowRunner)this.flowRunner("async-requestresponse").withPayload((Object)"0")).run();
        Message result = this.queueHandler.read("async-requestresponse-out", 5000L).getMessage();
        Message asyncResult = this.queueHandler.read("async-async-requestresponse-out", 5000L).getMessage();
        this.assertAsync(syncResult.getMessage(), result, asyncResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAsyncTransactionalEndpoint() throws Exception {
        Transaction transaction = (Transaction)Mockito.mock(Transaction.class);
        ((Transaction)Mockito.doAnswer(invocationOnMock -> {
            TransactionCoordination.getInstance().bindTransaction(transaction);
            return null;
        }).when((Object)transaction)).begin();
        try {
            CoreEvent syncResult = ((FlowRunner)this.flowRunner("async-tx").withPayload((Object)"0")).transactionally(TransactionConfigEnum.ACTION_ALWAYS_BEGIN, (TransactionFactory)new TestTransactionFactory(transaction)).run();
            Message result = this.queueHandler.read("async-tx-out", 5000L).getMessage();
            Message asyncResult = this.queueHandler.read("async-async-tx-out", 5000L).getMessage();
            this.assertAsync(syncResult.getMessage(), result, asyncResult);
        }
        finally {
            TransactionCoordination.getInstance().unbindTransaction(transaction);
        }
    }

    private void assertAsync(Message syncResult, Message result, Message asyncResult) throws Exception {
        Assert.assertNotNull((Object)syncResult);
        Assert.assertNotNull((Object)result);
        Assert.assertNotNull((Object)asyncResult);
        Assert.assertEquals((Object)"0ac", (Object)this.getPayloadAsString(syncResult));
        Assert.assertEquals((Object)"0ac", (Object)this.getPayloadAsString(result));
        Assert.assertEquals((Object)"0ab", (Object)this.getPayloadAsString(asyncResult));
    }

    @Test
    public void testChoiceWithoutOutboundEndpoints() throws Exception {
        Assert.assertEquals((Object)"foo Hello foo", (Object)this.getPayloadAsString(((FlowRunner)this.flowRunner("choice2").withPayload((Object)"foo")).run().getMessage()));
        Assert.assertEquals((Object)"bar Hello bar", (Object)this.getPayloadAsString(((FlowRunner)this.flowRunner("choice2").withPayload((Object)"bar")).run().getMessage()));
        Assert.assertEquals((Object)"egh Hello ?", (Object)this.getPayloadAsString(((FlowRunner)this.flowRunner("choice2").withPayload((Object)"egh")).run().getMessage()));
    }

    @Test
    public void testFlowRef() throws Exception {
        Message message = ((FlowRunner)this.flowRunner("flow-ref").withPayload((Object)"0")).run().getMessage();
        Assert.assertEquals((Object)"012xyzabc312xyzabc3", (Object)this.getPayloadAsString(message));
    }

    @Test
    public void testInvoke() throws Exception {
        Message message = ((FlowRunner)this.flowRunner("invoke").withPayload((Object)"0")).run().getMessage();
        Assert.assertEquals((Object)"0recieved", (Object)this.getPayloadAsString(message));
    }

    @Test
    public void testInvoke2() throws Exception {
        Message response = ((FlowRunner)((FlowRunner)this.flowRunner("invoke2").withPayload((Object)"0")).withInboundProperty("one", (Serializable)((Object)"header1val"))).run().getMessage();
        Assert.assertEquals((Object)"header1valrecieved", (Object)this.getPayloadAsString(response));
    }

    @Test
    public void testInvoke3() throws Exception {
        ((FlowRunner)this.flowRunner("invoke3").withPayload((Object)"0")).run();
    }

    @Test
    public void testInvoke4() throws Exception {
        ((FlowRunner)this.flowRunner("invoke4").withPayload((Object)"0")).run();
    }

    @Test
    public void testInvokeArrayInArgs() throws Exception {
        Message message = ((FlowRunner)this.flowRunner("invokeArrayInArgs").withPayload((Object)"0")).run().getMessage();
        Assert.assertThat((Object)message.getPayload().getValue(), (Matcher)CoreMatchers.equalTo((Object)EXPECTED_ARRAY_IN_ARGS_RESULT));
    }

    @Test
    public void testEnrichWithAttributes() throws Exception {
        Message muleMessage = ((FlowRunner)this.flowRunner("enrich").withPayload((Object)"0")).run().getMessage();
        Assert.assertEquals((Object)"0Hello", (Object)TestLegacyMessageUtils.getOutboundProperty((Message)muleMessage, (String)"helloHeader"));
    }

    @Test
    public void testEnrichWithElements() throws Exception {
        Message result = ((FlowRunner)this.flowRunner("enrich2").withPayload((Object)"0")).run().getMessage();
        Assert.assertEquals((Object)"0Hello", (Object)TestLegacyMessageUtils.getOutboundProperty((Message)result, (String)"helloHeader"));
        Assert.assertEquals((Object)"0Hello", (Object)TestLegacyMessageUtils.getOutboundProperty((Message)result, (String)"helloHeader2"));
    }

    @Test
    public void testEnrichUsingComponent() throws Exception {
        Message result = ((FlowRunner)this.flowRunner("enrichcomponent").withPayload((Object)"0")).run().getMessage();
        Assert.assertEquals((Object)"0", (Object)TestLegacyMessageUtils.getOutboundProperty((Message)result, (String)"echoHeader"));
    }

    @Test
    public void testEnrichUsingComponent2() throws Exception {
        Message result = ((FlowRunner)this.flowRunner("enrichcomponent2").withPayload((Object)"0")).run().getMessage();
        Assert.assertEquals((Object)"0", (Object)TestLegacyMessageUtils.getOutboundProperty((Message)result, (String)"echoHeader"));
    }

    @Test
    public void testLoggerMessage() throws Exception {
        ((FlowRunner)this.flowRunner("loggermessage").withPayload((Object)"0")).run();
    }

    @Test
    public void testLoggerHeader() throws Exception {
        ((FlowRunner)((FlowRunner)this.flowRunner("loggerheader").withPayload((Object)"0")).withOutboundProperty("toLog", (Serializable)((Object)"valueToLog"))).run();
    }

    @Test
    public void testPoll() throws Exception {
        Message message = this.queueHandler.read("poll-out", 5000L).getMessage();
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)" Hello fooout", (Object)this.getPayloadAsString(message));
    }

    @Test
    public void testPollFlowRef() throws Exception {
        Message message = this.queueHandler.read("poll2-out", 5000L).getMessage();
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)"nullpollappendout", (Object)this.getPayloadAsString(message));
    }

    @Test
    public void testSubFlowMessageFilter() throws Exception {
        ((FlowRunner)this.flowRunner("messagefiltersubflow").withPayload((Object)"0")).run();
        Message message = this.queueHandler.read("messagefiltersubflow-out", 5000L).getMessage();
        Assert.assertNotNull((Object)message);
    }

    @Test
    public void customMaxConcurrency() throws Exception {
        Flow flow = (Flow)this.registry.lookupByName("customMaxConcurrency").get();
        Assert.assertThat((Object)flow.getMaxConcurrency(), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    public static class CustomAppender
    extends StringAppendTransformer {
        public CustomAppender() {
            super("recieved");
        }
    }

    public static class ThreadSensingMessageProcessor
    implements Processor {
        public CoreEvent process(CoreEvent event) throws MuleException {
            return CoreEvent.builder((CoreEvent)event).message(Message.builder((Message)event.getMessage()).value((Object)Thread.currentThread()).build()).build();
        }
    }

    public static class Pojo {
        public void method() {
        }

        public void method(Object arg1, Object arg2) {
        }
    }
}

