/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.construct;

import java.io.Serializable;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.functional.api.component.TestConnectorQueueHandler;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.functional.api.flow.TransactionConfigEnum;
import org.mule.functional.junit4.TestLegacyMessageBuilder;
import org.mule.functional.junit4.TestLegacyMessageUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.tx.TransactionException;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.transaction.Transaction;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.runtime.core.api.transaction.TransactionFactory;
import org.mule.tck.testmodels.mule.TestTransactionFactory;
import org.mule.test.AbstractIntegrationTestCase;

public class FlowDefaultProcessingStrategyTestCase
extends AbstractIntegrationTestCase {
    private static final String PROCESSOR_THREAD = "processor-thread";
    private static final String FLOW_NAME = "Flow";
    private TestConnectorQueueHandler queueHandler;

    protected String getConfigFile() {
        return "org/mule/test/construct/flow-default-processing-strategy-config.xml";
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.queueHandler = new TestConnectorQueueHandler(this.registry);
    }

    @Test
    public void requestResponse() throws Exception {
        Message response = ((FlowRunner)this.flowRunner(FLOW_NAME).withPayload((Object)"test")).run().getMessage();
        Assert.assertThat((Object)response.getPayload().getValue().toString(), (Matcher)Matchers.is((Object)"test"));
        Message message = this.queueHandler.read("out", 5000L).getMessage();
        Assert.assertThat((Object)TestLegacyMessageUtils.getOutboundProperty((Message)message, (String)PROCESSOR_THREAD), (Matcher)Matchers.is((Matcher)Matchers.not((Object)Thread.currentThread().getName())));
    }

    @Test
    public void oneWay() throws Exception {
        ((FlowRunner)this.flowRunner(FLOW_NAME).withPayload((Object)"test")).run();
        Message message = this.queueHandler.read("out", 5000L).getMessage();
        Assert.assertThat((Object)TestLegacyMessageUtils.getOutboundProperty((Message)message, (String)PROCESSOR_THREAD), (Matcher)Matchers.is((Matcher)Matchers.not((Object)Thread.currentThread().getName())));
    }

    @Test
    public void requestResponseTransacted() throws Exception {
        Transaction transaction = this.createTransactionMock();
        try {
            ((FlowRunner)this.flowRunner(FLOW_NAME).withPayload((Object)"test")).transactionally(TransactionConfigEnum.ACTION_ALWAYS_BEGIN, (TransactionFactory)new TestTransactionFactory(transaction)).run();
            Message message = this.queueHandler.read("out", 5000L).getMessage();
            Assert.assertThat((Object)TestLegacyMessageUtils.getOutboundProperty((Message)message, (String)PROCESSOR_THREAD), (Matcher)Matchers.is((Object)Thread.currentThread().getName()));
        }
        finally {
            TransactionCoordination.getInstance().unbindTransaction(transaction);
        }
    }

    @Test
    public void oneWayTransacted() throws Exception {
        Transaction transaction = this.createTransactionMock();
        try {
            ((FlowRunner)this.flowRunner(FLOW_NAME).withPayload((Object)"test")).transactionally(TransactionConfigEnum.ACTION_ALWAYS_BEGIN, (TransactionFactory)new TestTransactionFactory(transaction)).run();
            Message message = this.queueHandler.read("out", 5000L).getMessage();
            Assert.assertThat((Object)TestLegacyMessageUtils.getOutboundProperty((Message)message, (String)PROCESSOR_THREAD), (Matcher)Matchers.is((Object)Thread.currentThread().getName()));
        }
        finally {
            TransactionCoordination.getInstance().unbindTransaction(transaction);
        }
    }

    private Transaction createTransactionMock() throws TransactionException {
        Transaction transaction = (Transaction)Mockito.mock(Transaction.class);
        ((Transaction)Mockito.doAnswer(invocationOnMock -> {
            TransactionCoordination.getInstance().bindTransaction(transaction);
            return null;
        }).when((Object)transaction)).begin();
        return transaction;
    }

    public static class ThreadSensingMessageProcessor
    implements Processor {
        public CoreEvent process(CoreEvent event) throws MuleException {
            return CoreEvent.builder((CoreEvent)event).message(new TestLegacyMessageBuilder(event.getMessage()).addOutboundProperty(FlowDefaultProcessingStrategyTestCase.PROCESSOR_THREAD, (Serializable)((Object)Thread.currentThread().getName())).build()).build();
        }
    }
}

