/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.construct;

import io.qameta.allure.Issue;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsCollectionWithSize;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.functional.api.exception.ExpectedError;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.functional.junit4.matchers.ThrowableMessageMatcher;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.notification.MessageProcessorNotification;
import org.mule.runtime.api.notification.MessageProcessorNotificationListener;
import org.mule.runtime.api.notification.NotificationListener;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.exception.Errors;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.test.AbstractIntegrationTestCase;

public class FlowRefTestCase
extends AbstractIntegrationTestCase {
    private static final String CONTEXT_DEPTH_MESSAGE = "Too many child contexts nested.";
    @Rule
    public ExpectedError expectedException = ExpectedError.none();
    @Rule
    public DynamicPort port = new DynamicPort("port");

    protected String getConfigFile() {
        return "org/mule/test/construct/flow-ref.xml";
    }

    @Test
    public void twoFlowRefsToSubFlow() throws Exception {
        CoreEvent muleEvent = ((FlowRunner)this.flowRunner("flow1").withPayload((Object)"0")).run();
        Assert.assertThat((Object)this.getPayloadAsString(muleEvent.getMessage()), (Matcher)Matchers.is((Object)"012xyzabc312xyzabc3"));
    }

    @Test
    public void dynamicFlowRef() throws Exception {
        Assert.assertThat((Object)((FlowRunner)((FlowRunner)this.flowRunner("flow2").withPayload((Object)"0")).withVariable("letter", (Object)"A")).run().getMessage().getPayload().getValue(), (Matcher)Matchers.is((Object)"0A"));
        Assert.assertThat((Object)((FlowRunner)((FlowRunner)this.flowRunner("flow2").withPayload((Object)"0")).withVariable("letter", (Object)"B")).run().getMessage().getPayload().getValue(), (Matcher)Matchers.is((Object)"0B"));
    }

    @Test
    public void dynamicFlowRefWithChoice() throws Exception {
        Assert.assertThat((Object)((FlowRunner)((FlowRunner)this.flowRunner("flow2").withPayload((Object)"0")).withVariable("letter", (Object)"C")).run().getMessage().getPayload().getValue(), (Matcher)Matchers.is((Object)"0A"));
    }

    @Test
    public void flowRefTargetToFlow() throws Exception {
        Assert.assertThat((Object)((TypedValue)this.flowRunner("targetToFlow").run().getVariables().get("flowRefResult")).getValue(), (Matcher)Matchers.is((Object)"result"));
    }

    @Test
    public void flowRefTargetToSubFlow() throws Exception {
        Assert.assertThat((Object)((TypedValue)this.flowRunner("targetToSubFlow").run().getVariables().get("flowRefResult")).getValue(), (Matcher)Matchers.is((Object)"result"));
    }

    @Test
    public void dynamicFlowRefWithScatterGather() throws Exception {
        Map messageList = (Map)((FlowRunner)((FlowRunner)this.flowRunner("flow2").withPayload((Object)"0")).withVariable("letter", (Object)"SG")).run().getMessage().getPayload().getValue();
        List payloads = messageList.values().stream().map(msg -> msg.getPayload().getValue()).collect(Collectors.toList());
        Assert.assertEquals((Object)"0A", payloads.get(0));
        Assert.assertEquals((Object)"0B", payloads.get(1));
    }

    @Test
    public void flowRefNotFound() throws Exception {
        this.expectedException.expectMessage(CoreMatchers.containsString((String)"No flow/sub-flow with name 'sub-flow-Z' found"));
        this.expectedException.expectErrorType(Errors.CORE_NAMESPACE_NAME, "ROUTING");
        Assert.assertThat((Object)((FlowRunner)((FlowRunner)this.flowRunner("flow2").withPayload((Object)"0")).withVariable("letter", (Object)"Z")).run().getMessage().getPayload().getValue(), (Matcher)Matchers.is((Object)"0C"));
    }

    @Test
    @Issue(value="MULE-14285")
    public void flowRefFlowErrorNotifications() throws Exception {
        ArrayList<MessageProcessorNotification> notificationList = new ArrayList<MessageProcessorNotification>();
        this.setupMessageProcessorNotificationListener(notificationList);
        Assert.assertThat((Object)this.flowRunner("flowRefFlowErrorNotifications").runExpectingException().getCause(), (Matcher)Matchers.instanceOf(IllegalStateException.class));
        this.assertNotifications(notificationList, "flowRefFlowErrorNotifications/processors/0");
    }

    @Test
    @Issue(value="MULE-14285")
    public void flowRefSubFlowErrorNotifications() throws Exception {
        ArrayList<MessageProcessorNotification> notificationList = new ArrayList<MessageProcessorNotification>();
        this.setupMessageProcessorNotificationListener(notificationList);
        Assert.assertThat((Object)this.flowRunner("flowRefSubFlowErrorNotifications").runExpectingException().getCause(), (Matcher)Matchers.instanceOf(IllegalStateException.class));
        this.assertNotifications(notificationList, "flowRefSubFlowErrorNotifications/processors/0");
    }

    private void setupMessageProcessorNotificationListener(List<MessageProcessorNotification> notificationList) {
        muleContext.getNotificationManager().addInterfaceToType(MessageProcessorNotificationListener.class, MessageProcessorNotification.class);
        muleContext.getNotificationManager().addListener((NotificationListener)((MessageProcessorNotificationListener)notification -> notificationList.add((MessageProcessorNotification)notification)));
    }

    private void assertNotifications(List<MessageProcessorNotification> notificationList, String name) {
        Assert.assertThat(notificationList, (Matcher)IsCollectionWithSize.hasSize((int)4));
        MessageProcessorNotification preNotification = notificationList.get(0);
        Assert.assertThat((Object)preNotification.getAction().getActionId(), (Matcher)CoreMatchers.equalTo((Object)1601));
        Assert.assertThat((Object)preNotification.getComponent().getLocation().getLocation(), (Matcher)CoreMatchers.equalTo((Object)name));
        Assert.assertThat((Object)preNotification.getException(), (Matcher)Matchers.is((Matcher)CoreMatchers.nullValue()));
        MessageProcessorNotification postNotification = notificationList.get(3);
        Assert.assertThat((Object)postNotification.getAction().getActionId(), (Matcher)CoreMatchers.equalTo((Object)1602));
        Assert.assertThat((Object)postNotification.getComponent().getLocation().getLocation(), (Matcher)CoreMatchers.equalTo((Object)name));
        Assert.assertThat((Object)postNotification.getException().getCause(), (Matcher)Matchers.instanceOf(IllegalStateException.class));
        Assert.assertThat((Object)postNotification.getEvent().getError().isPresent(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)((Error)postNotification.getEvent().getError().get()).getCause(), (Matcher)Matchers.instanceOf(IllegalStateException.class));
    }

    @Test
    public void recursive() throws Exception {
        this.flowRunner("recursiveCaller").runExpectingException(ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)CONTEXT_DEPTH_MESSAGE)));
    }

    @Test
    public void recursiveDynamic() throws Exception {
        this.flowRunner("recursiveDynamicCaller").runExpectingException(ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)CONTEXT_DEPTH_MESSAGE)));
    }

    @Test
    public void recursiveSubFlow() throws Exception {
        this.flowRunner("recursiveSubFlowCaller").runExpectingException(ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)CONTEXT_DEPTH_MESSAGE)));
    }

    @Test
    public void recursiveSubFlowDynamic() throws Exception {
        this.flowRunner("recursiveSubFlowDynamicCaller").runExpectingException(ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)CONTEXT_DEPTH_MESSAGE)));
    }
}

