/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.core;

import java.util.Arrays;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.security.SecurityContext;
import org.mule.runtime.api.security.SecurityProviderNotFoundException;
import org.mule.runtime.api.security.UnknownAuthenticationTypeException;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.security.AbstractAuthenticationFilter;
import org.mule.runtime.core.api.security.CryptoFailureException;
import org.mule.runtime.core.api.security.EncryptionStrategyNotFoundException;
import org.mule.runtime.core.api.transaction.Transaction;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.tck.processor.FlowAssert;
import org.mule.test.AbstractIntegrationTestCase;

public class NonBlockingFunctionalTestCase
extends AbstractIntegrationTestCase {
    public static String FOO = "foo";

    protected String getConfigFile() {
        return "non-blocking-test-config.xml";
    }

    @Test
    public void flow() throws Exception {
        ((FlowRunner)this.flowRunner("flow").withPayload((Object)"Test Message")).run();
    }

    @Test
    public void subFlow() throws Exception {
        ((FlowRunner)this.flowRunner("subFlow").withPayload((Object)"Test Message")).run();
    }

    @Test
    public void childFlow() throws Exception {
        ((FlowRunner)this.flowRunner("childFlow").withPayload((Object)"Test Message")).run();
    }

    public void childAsyncFlow() throws Exception {
        ((FlowRunner)this.flowRunner("childAsyncFlow").withPayload((Object)"Test Message")).run();
        FlowAssert.verify((String)"childAsyncFlowChild");
    }

    @Test
    public void processorChain() throws Exception {
        ((FlowRunner)this.flowRunner("processorChain").withPayload((Object)"Test Message")).run();
    }

    @Test
    public void securityFilter() throws Exception {
        ((FlowRunner)this.flowRunner("security-filter").withPayload((Object)"Test Message")).run();
    }

    @Test
    public void transformer() throws Exception {
        ((FlowRunner)this.flowRunner("transformer").withPayload((Object)"Test Message")).run();
    }

    @Test
    public void choice() throws Exception {
        ((FlowRunner)this.flowRunner("choice").withPayload((Object)"Test Message")).run();
    }

    @Test
    public void enricher() throws Exception {
        ((FlowRunner)this.flowRunner("enricher").withPayload((Object)"Test Message")).run();
    }

    @Test
    public void response() throws Exception {
        ((FlowRunner)this.flowRunner("response").withPayload((Object)"Test Message")).run();
    }

    @Test
    public void enricherIssue() throws Exception {
        CoreEvent result = ((FlowRunner)this.flowRunner("enricherIssue").withPayload((Object)"Test Message")).run();
        Assert.assertThat((Object)result.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"Test Message")));
    }

    @Test
    public void enricherIssueNonBlocking() throws Exception {
        CoreEvent result = ((FlowRunner)this.flowRunner("enricherIssueNonBlocking").withPayload((Object)"Test Message")).run();
        Assert.assertThat((Object)result.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"Test Message")));
    }

    @Test
    public void enricherFlowVar() throws Exception {
        CoreEvent result = ((FlowRunner)this.flowRunner("enricherFlowVar").withPayload((Object)"Test Message")).run();
        Assert.assertThat((Object)((TypedValue)result.getVariables().get(FOO)).getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)"Test Message")));
    }

    @Test
    public void async() throws Exception {
        ((FlowRunner)this.flowRunner("async").withPayload((Object)"Test Message")).run();
    }

    @Test
    public void catchExceptionStrategy() throws Exception {
        ((FlowRunner)this.flowRunner("catchExceptionStrategy").withPayload((Object)"Test Message")).run();
        FlowAssert.verify((String)"catchExceptionStrategyChild");
    }

    @Test
    public void rollbackExceptionStrategy() throws Exception {
        ((FlowRunner)this.flowRunner("rollbackExceptionStrategy").withPayload((Object)"Test Message")).run();
        FlowAssert.verify((String)"rollbackExceptionStrategyChild");
    }

    @Test
    public void nonTransactionalTry() throws Exception {
        ((FlowRunner)this.flowRunner("nonTransactionalTry").withPayload((Object)"Test Message")).run();
    }

    @Test
    public void nonTransactionalTryErrorHandler() throws Exception {
        ((FlowRunner)this.flowRunner("nonTransactionalTryErrorHandler").withPayload((Object)"Test Message")).run();
    }

    @Test
    public void tansactionalTry() throws Exception {
        ((FlowRunner)this.flowRunner("transactionalTry").withPayload((Object)"Test Message")).run();
    }

    @Test
    public void transactionalTryErrorHandler() throws Exception {
        ((FlowRunner)this.flowRunner("transactionalTryErrorHandler").withPayload((Object)"Test Message")).run();
    }

    @Test
    public void childDefaultFlow() throws Exception {
        ((FlowRunner)this.flowRunner("childDefaultFlow").withPayload((Object)"Test Message")).run();
        FlowAssert.verify((String)"childDefaultFlowChild");
    }

    @Test
    public void untilSuccessfulNoRetry() throws Exception {
        ((FlowRunner)this.flowRunner("untilSuccessfulNoRetry").withPayload((Object)"Test Message")).run();
    }

    @Test
    public void untilSuccessfulNoRetryNonBlockingAfterScope() throws Exception {
        ((FlowRunner)this.flowRunner("untilSuccessfulNoRetryNonBlockingAfterScope").withPayload((Object)"Test Message")).run();
    }

    @Test
    public void untilSuccessfulWithRetryExceptionBefore() throws Exception {
        ((FlowRunner)this.flowRunner("untilSuccessfulWithRetryExceptionBefore").withPayload((Object)"Test Message")).run();
    }

    @Test
    public void untilSuccessfulWithRetryExceptionAfter() throws Exception {
        ((FlowRunner)this.flowRunner("untilSuccessfulWithRetryExceptionAfter").withPayload((Object)"Test Message")).run();
    }

    @Test
    public void untilSuccessfulWithRetryNonBlockingAfterScope() throws Exception {
        ((FlowRunner)this.flowRunner("untilSuccessfulWithRetryNonBlockingAfterScope").withPayload((Object)"Test Message")).run();
    }

    @Test
    public void untilSuccessfulWithRetryTransactional() throws Exception {
        TransactionCoordination.getInstance().bindTransaction((Transaction)Mockito.mock(Transaction.class));
        ((FlowRunner)this.flowRunner("untilSuccessfulWithRetryTransactional").withPayload((Object)"Test Message")).run();
    }

    @Test
    public void foreach() throws Exception {
        ((FlowRunner)this.flowRunner("foreach").withPayload(Arrays.asList({"1", "2", "3"}, {"a", "b", "c"}))).run();
    }

    public static class CustomSecurityFilter
    extends AbstractAuthenticationFilter {
        protected void doInitialise() throws InitialisationException {
        }

        public SecurityContext authenticate(CoreEvent event) throws SecurityException, UnknownAuthenticationTypeException, CryptoFailureException, SecurityProviderNotFoundException, EncryptionStrategyNotFoundException, InitialisationException {
            return event.getSecurityContext();
        }
    }
}

