/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.core.context.notification;

import java.util.function.Consumer;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runners.Parameterized;
import org.mule.functional.api.exception.FunctionalTestException;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.notification.ErrorHandlerNotification;
import org.mule.runtime.api.notification.IntegerAction;
import org.mule.runtime.api.notification.Notification;
import org.mule.test.core.context.notification.AbstractNotificationTestCase;
import org.mule.test.core.context.notification.Node;
import org.mule.test.core.context.notification.RestrictedNode;
import org.mule.test.runner.RunnerDelegateTo;

@RunnerDelegateTo(value=Parameterized.class)
public class ErrorHandlerNotificationTestCase
extends AbstractNotificationTestCase {
    private String flowName;
    private Consumer<ExpectedException> expected;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Parameterized.Parameters(name="{0}")
    public static Object[][] params() {
        return new Object[][]{{"catch-es", expected -> {}}, {"choice-es", expected -> {}}, {"rollback-es", expected -> expected.expectCause(Matchers.instanceOf(FunctionalTestException.class))}, {"default-es", expected -> expected.expectCause(Matchers.instanceOf(FunctionalTestException.class))}};
    }

    public ErrorHandlerNotificationTestCase(String flowName, Consumer<ExpectedException> expected) {
        this.flowName = flowName;
        this.expected = expected;
    }

    protected String getConfigFile() {
        return "org/mule/test/integration/notifications/exception-strategy-notification-test-flow.xml";
    }

    @Test
    public void doTest() throws Exception {
        this.expected.accept(this.expectedException);
        try {
            Assert.assertNotNull((Object)((FlowRunner)this.flowRunner(this.flowName).withPayload((Object)"test")).run());
        }
        finally {
            this.assertNotifications();
        }
    }

    @Override
    public RestrictedNode getSpecification() {
        return new Node().serial(this.node((Notification.Action)new IntegerAction(2001)).serial(this.node((Notification.Action)new IntegerAction(2002))));
    }

    private RestrictedNode node(Notification.Action action) {
        return new Node(ErrorHandlerNotification.class, action);
    }

    @Override
    public void validateSpecification(RestrictedNode spec) throws Exception {
    }
}

