/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.core.context.notification;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.collection.IsCollectionWithSize;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.mule.functional.api.event.TestLegacyEventUtils;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.notification.MessageProcessorNotification;
import org.mule.runtime.api.notification.MessageProcessorNotificationListener;
import org.mule.runtime.core.api.context.notification.ProcessorsTrace;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.test.AbstractIntegrationTestCase;

public class ProcessorsTraceTestCase
extends AbstractIntegrationTestCase {
    @Rule
    public SystemProperty flowTraceEnabled = new SystemProperty("mule.flowTrace", "true");

    protected String getConfigFile() {
        return "org/mule/test/integration/notifications/processors-trace-config.xml";
    }

    @Before
    public void before() {
        muleContext.getNotificationManager().addInterfaceToType(MessageProcessorNotificationListener.class, MessageProcessorNotification.class);
        ProcessorsTraceAsserter.processorsTraceToAssert = null;
        ProcessorsTraceAsyncAsserter.latch = new CountDownLatch(1);
    }

    @Test
    public void flowStatic() throws Exception {
        ((FlowRunner)this.flowRunner("flowStatic").withPayload((Object)"test")).run();
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, this.hasExecutedProcessors("flowStatic/processors/0", "flow/processors/0"));
    }

    @Test
    public void subFlowStatic() throws Exception {
        ((FlowRunner)this.flowRunner("subFlowStatic").withPayload((Object)"test")).run();
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, this.hasExecutedProcessors("subFlowStatic/processors/0", "subFlow/processors/0"));
    }

    @Test
    public void flowDynamic() throws Exception {
        ((FlowRunner)this.flowRunner("flowDynamic").withPayload((Object)"test")).run();
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, this.hasExecutedProcessors("flowDynamic/processors/0", "flow/processors/0"));
    }

    @Test
    public void subFlowDynamic() throws Exception {
        ((FlowRunner)this.flowRunner("subFlowDynamic").withPayload((Object)"test")).run();
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, this.hasExecutedProcessors("subFlowDynamic/processors/0", "subFlow/processors/0"));
    }

    @Test
    public void secondFlowStatic() throws Exception {
        ((FlowRunner)this.flowRunner("secondFlowStatic").withPayload((Object)"test")).run();
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, this.hasExecutedProcessors("secondFlowStatic/processors/0", "flow/processors/0", "secondFlowStatic/processors/1", "flow/processors/0"));
    }

    @Test
    public void secondSubFlowStatic() throws Exception {
        ((FlowRunner)this.flowRunner("secondSubFlowStatic").withPayload((Object)"test")).run();
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, this.hasExecutedProcessors("secondSubFlowStatic/processors/0", "subFlow/processors/0", "secondSubFlowStatic/processors/1", "subFlow/processors/0"));
    }

    @Test
    public void secondFlowDynamic() throws Exception {
        ((FlowRunner)this.flowRunner("secondFlowDynamic").withPayload((Object)"test")).run();
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, this.hasExecutedProcessors("secondFlowDynamic/processors/0", "flow/processors/0", "secondFlowDynamic/processors/1", "flow/processors/0"));
    }

    @Test
    public void secondSubFlowDynamic() throws Exception {
        ((FlowRunner)this.flowRunner("secondSubFlowDynamic").withPayload((Object)"test")).run();
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, this.hasExecutedProcessors("secondSubFlowDynamic/processors/0", "subFlow/processors/0", "secondSubFlowDynamic/processors/1", "subFlow/processors/0"));
    }

    @Test
    public void flowStaticWithAsync() throws Exception {
        ((FlowRunner)this.flowRunner("flowStaticWithAsync").withPayload((Object)"test")).run();
        ProcessorsTraceAsyncAsserter.latch.await(1L, TimeUnit.SECONDS);
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, this.hasExecutedProcessors("flowStaticWithAsync/processors/0", "flowStaticWithAsync/processors/0/processors/0", "flowInAsync/processors/0"));
    }

    @Test
    public void subFlowStaticWithAsync() throws Exception {
        ((FlowRunner)this.flowRunner("subFlowStaticWithAsync").withPayload((Object)"test")).run();
        ProcessorsTraceAsyncAsserter.latch.await(1L, TimeUnit.SECONDS);
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, this.hasExecutedProcessors("subFlowStaticWithAsync/processors/0", "subFlowStaticWithAsync/processors/0/processors/0", "subFlowInAsync/processors/0"));
    }

    @Test
    public void flowDynamicWithAsync() throws Exception {
        ((FlowRunner)this.flowRunner("flowDynamicWithAsync").withPayload((Object)"test")).run();
        ProcessorsTraceAsyncAsserter.latch.await(1L, TimeUnit.SECONDS);
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, this.hasExecutedProcessors("flowDynamicWithAsync/processors/0", "flowDynamicWithAsync/processors/0/processors/0", "flowInAsync/processors/0"));
    }

    @Test
    public void subFlowDynamicWithAsync() throws Exception {
        ((FlowRunner)this.flowRunner("subFlowDynamicWithAsync").withPayload((Object)"test")).run();
        ProcessorsTraceAsyncAsserter.latch.await(1L, TimeUnit.SECONDS);
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, this.hasExecutedProcessors("subFlowDynamicWithAsync/processors/0", "subFlowDynamicWithAsync/processors/0/processors/0", "subFlowInAsync/processors/0"));
    }

    @Test
    public void flowStaticWithEnricher() throws Exception {
        ((FlowRunner)this.flowRunner("flowStaticWithEnricher").withPayload((Object)"test")).run();
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, this.hasExecutedProcessors("flowStaticWithEnricher/processors/0", "flowStaticWithEnricher/processors/0/processors/0", "flow/processors/0"));
    }

    @Test
    public void subFlowStaticWithEnricher() throws Exception {
        ((FlowRunner)this.flowRunner("subFlowStaticWithEnricher").withPayload((Object)"test")).run();
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, this.hasExecutedProcessors("subFlowStaticWithEnricher/processors/0", "subFlowStaticWithEnricher/processors/0/processors/0", "subFlow/processors/0"));
    }

    @Test
    public void flowDynamicWithEnricher() throws Exception {
        ((FlowRunner)this.flowRunner("flowDynamicWithEnricher").withPayload((Object)"test")).run();
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, this.hasExecutedProcessors("flowDynamicWithEnricher/processors/0", "flowDynamicWithEnricher/processors/0/processors/0", "flow/processors/0"));
    }

    @Test
    public void subFlowDynamicWithEnricher() throws Exception {
        ((FlowRunner)this.flowRunner("subFlowDynamicWithEnricher").withPayload((Object)"test")).run();
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, this.hasExecutedProcessors("subFlowDynamicWithEnricher/processors/0", "subFlowDynamicWithEnricher/processors/0/processors/0", "subFlow/processors/0"));
    }

    @Test
    public void flowStaticWithChoice() throws Exception {
        ((FlowRunner)this.flowRunner("flowStaticWithChoice").withPayload((Object)"test")).run();
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, this.hasExecutedProcessors("flowStaticWithChoice/processors/0", "flowStaticWithChoice/processors/0/route/0/processors/0", "flow/processors/0"));
    }

    @Test
    public void subFlowStaticWithChoice() throws Exception {
        ((FlowRunner)this.flowRunner("subFlowStaticWithChoice").withPayload((Object)"test")).run();
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, this.hasExecutedProcessors("subFlowStaticWithChoice/processors/0", "subFlowStaticWithChoice/processors/0/route/0/processors/0", "subFlow/processors/0"));
    }

    @Test
    public void flowDynamicWithChoice() throws Exception {
        ((FlowRunner)this.flowRunner("flowDynamicWithChoice").withPayload((Object)"test")).run();
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, this.hasExecutedProcessors("flowDynamicWithChoice/processors/0", "flowDynamicWithChoice/processors/0/route/0/processors/0", "flow/processors/0"));
    }

    @Test
    public void subFlowDynamicWithChoice() throws Exception {
        ((FlowRunner)this.flowRunner("subFlowDynamicWithChoice").withPayload((Object)"test")).run();
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, this.hasExecutedProcessors("subFlowDynamicWithChoice/processors/0", "subFlowDynamicWithChoice/processors/0/route/0/processors/0", "subFlow/processors/0"));
    }

    @Test
    public void flowStaticWithScatterGather() throws Exception {
        ((FlowRunner)this.flowRunner("flowStaticWithScatterGather").withPayload((Object)"test")).run();
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, this.hasExecutedProcessorsNoOrder("flowStaticWithScatterGather/processors/0", "flowStaticWithScatterGather/processors/0/route/0/processors/0", "flowStaticWithScatterGather/processors/0/route/1/processors/0", "flow/processors/0"));
    }

    @Test
    public void subFlowStaticWithScatterGather() throws Exception {
        ((FlowRunner)this.flowRunner("subFlowStaticWithScatterGather").withPayload((Object)"test")).run();
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, this.hasExecutedProcessorsNoOrder("subFlowStaticWithScatterGather/processors/0", "subFlowStaticWithScatterGather/processors/0/route/0/processors/0", "subFlowStaticWithScatterGather/processors/0/route/1/processors/0", "subFlow/processors/0"));
    }

    @Ignore(value="MULE-6926: flaky test")
    @Test
    public void flowDynamicWithScatterGather() throws Exception {
        ((FlowRunner)this.flowRunner("flowDynamicWithScatterGather").withPayload((Object)"test")).run();
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, this.hasExecutedProcessorsNoOrder("flowDynamicWithScatterGather/processors/0", "flowDynamicWithScatterGather/processors/0/route/0/processors/0", "flowDynamicWithScatterGather/processors/0/route/1/processors/0", "flow/processors/0"));
    }

    @Test
    public void subFlowDynamicWithScatterGather() throws Exception {
        ((FlowRunner)this.flowRunner("subFlowDynamicWithScatterGather").withPayload((Object)"test")).run();
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, this.hasExecutedProcessorsNoOrder("subFlowDynamicWithScatterGather/processors/0", "subFlowDynamicWithScatterGather/processors/0/route/0/processors/0", "subFlowDynamicWithScatterGather/processors/0/route/1/processors/0", "subFlow/processors/0"));
    }

    @Test
    public void flowStaticWithScatterGatherChain() throws Exception {
        ((FlowRunner)this.flowRunner("flowStaticWithScatterGatherChain").withPayload((Object)"test")).run();
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, this.hasExecutedProcessorsNoOrder("flowStaticWithScatterGatherChain/processors/0", "flowStaticWithScatterGatherChain/processors/0/route/0/processors/0", "flowStaticWithScatterGatherChain/processors/0/route/1/processors/0", "flow/processors/0"));
    }

    @Ignore(value="MULE-6926: flaky test")
    @Test
    public void subFlowStaticWithScatterGatherChain() throws Exception {
        ((FlowRunner)this.flowRunner("subFlowStaticWithScatterGatherChain").withPayload((Object)"test")).run();
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, this.hasExecutedProcessorsNoOrder("subFlowStaticWithScatterGatherChain/processors/0", "subFlowStaticWithScatterGatherChain/processors/0/route/0/processors/0", "subFlowStaticWithScatterGatherChain/processors/0/route/1/processors/0", "subFlow/processors/0"));
    }

    @Test
    public void flowDynamicWithScatterGatherChain() throws Exception {
        ((FlowRunner)this.flowRunner("flowDynamicWithScatterGatherChain").withPayload((Object)"test")).run();
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, this.hasExecutedProcessorsNoOrder("flowDynamicWithScatterGatherChain/processors/0", "flowDynamicWithScatterGatherChain/processors/0/route/0/processors/0", "flowDynamicWithScatterGatherChain/processors/0/route/1/processors/0", "flow/processors/0"));
    }

    @Test
    public void subFlowDynamicWithScatterGatherChain() throws Exception {
        ((FlowRunner)this.flowRunner("subFlowDynamicWithScatterGatherChain").withPayload((Object)"test")).run();
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)ProcessorsTraceAsserter.processorsTraceToAssert, this.hasExecutedProcessorsNoOrder("subFlowDynamicWithScatterGatherChain/processors/0", "subFlowDynamicWithScatterGatherChain/processors/0/route/0/processors/0", "subFlowDynamicWithScatterGatherChain/processors/0/route/1/processors/0", "subFlow/processors/0"));
    }

    private Matcher<ProcessorsTrace> hasExecutedProcessors(String ... expectedProcessors) {
        return new ProcessorsMatcher(expectedProcessors){

            @Override
            protected void doMatch(ProcessorsTrace processorsTrace, int i, String expectedProcessor) {
                Matcher processorItemMatcher = CoreMatchers.startsWith((String)(expectedProcessor + " @"));
                if (!processorItemMatcher.matches(processorsTrace.getExecutedProcessors().get(i))) {
                    this.failed.add(processorItemMatcher);
                }
            }
        };
    }

    private Matcher<ProcessorsTrace> hasExecutedProcessorsNoOrder(String ... expectedProcessors) {
        return new ProcessorsMatcher(expectedProcessors){

            @Override
            protected void doMatch(ProcessorsTrace processorsTrace, int i, String expectedProcessor) {
                Matcher processorItemMatcher = CoreMatchers.hasItem((Matcher)CoreMatchers.startsWith((String)(expectedProcessor + " @")));
                if (!processorItemMatcher.matches((Object)processorsTrace.getExecutedProcessors())) {
                    this.failed.add(processorItemMatcher);
                }
            }
        };
    }

    private abstract class ProcessorsMatcher
    extends TypeSafeMatcher<ProcessorsTrace> {
        protected List<Matcher> failed = new ArrayList<Matcher>();
        protected String[] expectedProcessors;

        public ProcessorsMatcher(String[] expectedProcessors) {
            this.expectedProcessors = expectedProcessors;
        }

        protected boolean matchesSafely(ProcessorsTrace processorsTrace) {
            Matcher sizeMatcher = IsCollectionWithSize.hasSize((int)this.expectedProcessors.length);
            if (!sizeMatcher.matches((Object)processorsTrace.getExecutedProcessors())) {
                this.failed.add(sizeMatcher);
            }
            int i = 0;
            for (String expectedProcessor : this.expectedProcessors) {
                this.doMatch(processorsTrace, i, expectedProcessor);
                ++i;
            }
            return this.failed.isEmpty();
        }

        protected abstract void doMatch(ProcessorsTrace var1, int var2, String var3);

        public void describeTo(Description description) {
            description.appendValue(Arrays.asList(this.expectedProcessors));
        }

        protected void describeMismatchSafely(ProcessorsTrace item, Description description) {
            description.appendText("was ").appendValue((Object)item.getExecutedProcessors());
        }
    }

    public static class ProcessorsTraceAsyncAsserter
    extends ProcessorsTraceAsserter {
        public static CountDownLatch latch;

        @Override
        public CoreEvent process(CoreEvent event) throws MuleException {
            super.process(event);
            latch.countDown();
            return event;
        }
    }

    public static class ProcessorsTraceAsserter
    implements Processor {
        public static ProcessorsTrace processorsTraceToAssert;

        public CoreEvent process(CoreEvent event) throws MuleException {
            processorsTraceToAssert = TestLegacyEventUtils.getProcessorsTrace((CoreEvent)event);
            return event;
        }
    }
}

