/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.core.routing.outbound;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.functional.api.component.EventCallback;
import org.mule.functional.api.component.TestConnectorQueueHandler;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.test.AbstractIntegrationTestCase;

public class AggregationTimeoutTestCase
extends AbstractIntegrationTestCase {
    private static final CountDownLatch blockExecution = new CountDownLatch(1);
    public static final String PROCESS_EVENT = "process";
    public static final String BLOCK_EVENT = "block";
    public static final String PROCESSED_EVENT = "processed";

    protected String getConfigFile() {
        return "org/mule/test/integration/routing/outbound/aggregation-timeout-config.xml";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void timeoutsAggregationWithPersistentStore() throws Exception {
        ArrayList<String> inputData = new ArrayList<String>();
        inputData.add(PROCESS_EVENT);
        inputData.add(BLOCK_EVENT);
        try {
            TestConnectorQueueHandler queueHandler = new TestConnectorQueueHandler(this.registry);
            ((FlowRunner)this.flowRunner("main").withPayload(inputData)).dispatchAsync(muleContext.getSchedulerService().ioScheduler(muleContext.getSchedulerBaseConfig().withShutdownTimeout(0L, TimeUnit.SECONDS)));
            Message response = queueHandler.read("testOut", 5000L).getMessage();
            Assert.assertThat((Object)response.getPayload().getValue(), (Matcher)Matchers.instanceOf(List.class));
            List payloads = ((List)response.getPayload().getValue()).stream().map(m -> (String)m.getPayload().getValue()).collect(Collectors.toList());
            Assert.assertThat((Object)payloads.size(), (Matcher)Matchers.equalTo((Object)1));
            Assert.assertThat(payloads, (Matcher)Matchers.hasItem((Object)PROCESSED_EVENT));
        }
        finally {
            blockExecution.countDown();
        }
    }

    public static class BlockExecutionComponent
    implements EventCallback {
        public void eventReceived(CoreEvent event, Object component, MuleContext muleContext) throws Exception {
            if (event.getMessage().getPayload().getValue().equals(AggregationTimeoutTestCase.BLOCK_EVENT)) {
                blockExecution.await();
            }
        }
    }
}

