/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.core.transformers.simple;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mule.functional.junit4.TestLegacyMessageBuilder;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.Banana;
import org.mule.tck.testmodels.fruit.FruitBasket;
import org.mule.tck.testmodels.fruit.FruitBowl;
import org.mule.test.AbstractIntegrationTestCase;

public class ExpressionTransformerELTestCase
extends AbstractIntegrationTestCase {
    private Transformer transformer;

    protected String getConfigFile() {
        return "org/mule/test/transformers/expression-transformers-el-test.xml";
    }

    @Test
    public void testExecutionWithCorrectMessage() throws Exception {
        this.testExecutionWithCorrectMessage("testTransformer");
    }

    @After
    public void after() {
        this.transformer.dispose();
    }

    private void testExecutionWithCorrectMessage(String name) throws Exception {
        this.transformer = (Transformer)this.registry.lookupByName(name).get();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("foo", "moo");
        props.put("bar", "mar");
        Message message = new TestLegacyMessageBuilder().value((Object)new FruitBowl(new Apple(), new Banana())).outboundProperties(props).build();
        Object result = this.transformer.transform((Object)message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.getClass().isArray());
        Object o1 = ((Object[])result)[0];
        Assert.assertTrue((boolean)(o1 instanceof FruitBasket));
        Object o2 = ((Object[])result)[1];
        Assert.assertTrue((boolean)(o2 instanceof Map));
        Map map = (Map)o2;
        Assert.assertEquals((long)2L, (long)map.size());
        Assert.assertEquals((Object)"moo", map.get("foo"));
        Assert.assertEquals((Object)"mar", map.get("bar"));
    }

    @Test
    public void testExecutionWithPartialMissingOptionalParams() throws Exception {
        this.transformer = (Transformer)this.registry.lookupByName("testTransformer").get();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("foo", "moo");
        Message message = new TestLegacyMessageBuilder().value((Object)new FruitBowl(new Apple(), new Banana())).outboundProperties(props).build();
        Object result = this.transformer.transform((Object)message);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.getClass().isArray());
        Object o1 = ((Object[])result)[0];
        Assert.assertTrue((boolean)(o1 instanceof FruitBasket));
        Object o2 = ((Object[])result)[1];
        Assert.assertTrue((boolean)(o2 instanceof Map));
        Map map = (Map)o2;
        Assert.assertEquals((long)2L, (long)map.size());
        Assert.assertEquals((Object)"moo", map.get("foo"));
    }

    @Test
    public void testTransformerConfigWithSingleArgument() throws Exception {
        this.transformer = (Transformer)this.registry.lookupByName("testTransformer2").get();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("foo", "moo");
        props.put("bar", "mar");
        Message message = new TestLegacyMessageBuilder().value((Object)new FruitBowl(new Apple(), new Banana())).outboundProperties(props).build();
        Object result = this.transformer.transform((Object)message);
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.getClass().isArray());
        Assert.assertTrue((boolean)(result instanceof List));
        List list = (List)result;
        Assert.assertTrue((boolean)list.contains("moo"));
        Assert.assertTrue((boolean)list.contains("mar"));
    }

    @Test
    public void testTransformerConfigWithSingleArgumentShortcutConfig() throws Exception {
        this.testTransformerConfigWithSingleArgumentShortcutConfig("testTransformer4");
    }

    private void testTransformerConfigWithSingleArgumentShortcutConfig(String name) throws Exception {
        this.transformer = (Transformer)this.registry.lookupByName(name).get();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("foo", "moo");
        props.put("bar", "mar");
        Message message = new TestLegacyMessageBuilder().value((Object)new FruitBowl(new Apple(), new Banana())).outboundProperties(props).build();
        Object result = this.transformer.transform((Object)message);
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.getClass().isArray());
        Assert.assertTrue((boolean)(result instanceof List));
        List list = (List)result;
        Assert.assertTrue((boolean)list.contains("moo"));
        Assert.assertTrue((boolean)list.contains("mar"));
    }
}

