/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.el;

import java.text.DateFormat;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.tck.MuleTestUtils;
import org.mule.test.AbstractIntegrationTestCase;

public class ExpressionLanguageConfigTestCase
extends AbstractIntegrationTestCase {
    ExpressionManager el;

    protected String getConfigFile() {
        return "org/mule/test/el/expression-language-config.xml";
    }

    @Before
    public void setup() {
        this.el = muleContext.getExpressionManager();
    }

    @Test
    public void testExpressionLanguageImport() {
        Assert.assertEquals(Locale.class, (Object)this.evaluate("loc"));
    }

    @Test
    public void testExpressionLanguageImportNoName() {
        Assert.assertEquals(DateFormat.class, (Object)this.evaluate("DateFormat"));
    }

    @Test
    public void testExpressionLanguageAlias() {
        Assert.assertEquals((Object)muleContext.getConfiguration().getId(), (Object)this.evaluate("appName"));
    }

    @Test
    public void testExpressionLanguageGlobalFunction() {
        Assert.assertEquals((Object)"hi", (Object)this.evaluate("echo('hi')"));
    }

    @Test
    public void testExpressionLanguageGlobalFunctionFromFile() {
        Assert.assertEquals((Object)"hi", (Object)this.evaluate("echo2('hi')"));
    }

    @Test
    public void testExpressionLanguageGlobalFunctionUsingStaticContext() {
        Assert.assertEquals((Object)("Hello " + muleContext.getConfiguration().getId() + "!"), (Object)this.evaluate("hello()"));
    }

    @Test
    public void testExpressionLanguageGlobalFunctionUsingMessageContext() throws Exception {
        Assert.assertEquals((Object)"123appended", (Object)this.el.evaluate("mel:appendPayload()", CoreEvent.builder((CoreEvent)this.testEvent()).message(Message.of((Object)"123")).build(), MuleTestUtils.getTestFlow((MuleContext)muleContext).getLocation()).getValue());
    }

    @Test
    public void testExpressionLanguageGlobalFunctionUsingMessageContextAndImport() throws Exception {
        Assert.assertEquals((Object)"321", (Object)this.el.evaluate("mel:reversePayload()", CoreEvent.builder((CoreEvent)this.testEvent()).message(Message.of((Object)"123")).build(), MuleTestUtils.getTestFlow((MuleContext)muleContext).getLocation()).getValue());
    }

    @Test
    public void testExpressionLanguageExecuteElement() throws Exception {
        ((FlowRunner)this.flowRunner("flow").withPayload((Object)"foo")).run();
    }

    private Object evaluate(String expression) {
        return this.el.evaluate("mel:" + expression).getValue();
    }
}

