/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.exceptions;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.sql.SQLDataException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mule.functional.api.component.FunctionalTestProcessor;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.functional.junit4.matchers.MessageMatchers;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.security.UnauthorisedException;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.retry.policy.RetryPolicyExhaustedException;
import org.mule.runtime.core.api.transformer.MessageTransformerException;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.tck.junit4.matcher.ErrorTypeMatcher;
import org.mule.test.AbstractIntegrationTestCase;

@Feature(value="Error Handling")
@Story(value="Error Handler")
public class ErrorHandlerTestCase
extends AbstractIntegrationTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private I18nMessage mockMessage = (I18nMessage)Mockito.mock(I18nMessage.class);
    private Processor mockMP = (Processor)Mockito.mock(Processor.class);

    protected String getConfigFile() {
        return "org/mule/test/integration/exceptions/error-handler.xml";
    }

    @Test
    public void testMatchesCorrectExceptionStrategy() throws Exception {
        this.callAndThrowException(new IllegalStateException(), "0 catch-2");
    }

    @Test
    public void testMatchesCorrectExceptionStrategyUsingWrapper() throws Exception {
        this.callAndThrowException((Exception)((Object)new GenericMuleException(I18nMessageFactory.createStaticMessage((String)""), new IllegalStateException())), "0 catch-2");
    }

    @Test
    public void testMatchesCorrectExceptionStrategyUsingWrapperAndCause() throws Exception {
        this.callAndThrowException((Exception)((Object)new GenericMuleException(I18nMessageFactory.createStaticMessage((String)""), new RuntimeException(new IllegalStateException()))), "0 catch-2");
    }

    @Test
    public void testMatchesCorrectExceptionStrategyUsingBaseClass() throws Exception {
        this.callAndThrowException(new BaseException(), "0 catch-3");
    }

    @Test
    public void testMatchesCorrectExceptionStrategyUsingSubtypeClass() throws Exception {
        this.callAndThrowException((Exception)((Object)new GenericMuleException(I18nMessageFactory.createStaticMessage((String)""), new SubtypeException())), "0 catch-4");
    }

    @Test
    public void testMatchesCorrectExceptionStrategyUsingSubtypeSubtypeClass() throws Exception {
        this.callAndThrowException(new SubtypeSubtypeException(), "0 catch-4");
    }

    @Test
    public void testMatchesCorrectExceptionStrategyUsingRegex() throws Exception {
        this.callAndThrowException(new AnotherTypeMyException(), "0 catch-5");
    }

    @Test
    public void testMatchesCorrectExceptionStrategyUsingGroovyExpressionEvaluator() throws Exception {
        this.callAndThrowException("groovy", new SQLDataException(), "groovy catch-6");
    }

    @Test
    public void testMatchesCorrectExceptionStrategyUsingStartsWithWildcard() throws Exception {
        this.callAndThrowException(new StartsWithException(), "0 catch-7");
    }

    @Test
    public void testMatchesCorrectExceptionStrategyUsingFinishesWithWildcard() throws Exception {
        this.callAndThrowException(new ThisExceptionFinishesWithException(), "0 catch-8");
    }

    @Test
    public void testMatchesCorrectExceptionStrategyUsingMatchesAll() throws Exception {
        this.callAndThrowException(new AnotherTotallyDifferentKindOfException(), "0 catch-9");
    }

    @Test
    public void testMatchesCorrectExceptionStrategyUsingFinishesWithSomethingElse() throws Exception {
        this.callAndThrowException(new ThisExceptionFinishesWithSomethingElse(), "0 groovified");
    }

    @Test
    public void testMatchesCorrectExceptionUsingNoCause() throws Exception {
        this.expectedException.expectCause(Is.is((Matcher)IsInstanceOf.instanceOf(GenericMuleException.class)));
        this.callAndThrowException((Exception)((Object)new GenericMuleException(I18nMessageFactory.createStaticMessage((String)""))), null);
    }

    @Test
    public void transformation() throws Exception {
        String expectedMessage = "0 transformation";
        Transformer mockTransformer = (Transformer)Mockito.mock(Transformer.class);
        this.callTypeAndThrowException((Exception)new MessageTransformerException(this.mockMessage, mockTransformer, null), expectedMessage);
        this.callTypeAndThrowException((Exception)new TransformerException(this.mockMessage, mockTransformer), expectedMessage);
    }

    @Test
    public void expression() throws Exception {
        this.callTypeAndThrowException((Exception)new ExpressionRuntimeException(this.mockMessage, (Throwable)new Exception()), "0 expression");
    }

    @Test
    public void connectivity() throws Exception {
        this.callTypeAndThrowException((Exception)new RetryPolicyExhaustedException(this.mockMessage, Mockito.mock(Initialisable.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{Component.class}))), "0 connectivity");
    }

    @Test
    public void security() throws Exception {
        this.callTypeAndThrowException((Exception)new UnauthorisedException(this.mockMessage), "0 security");
    }

    @Test
    public void any() throws Exception {
        String expectedMessage = "0 any";
        this.callTypeAndThrowException(new RuntimeException(), expectedMessage);
        this.callTypeAndThrowException((Exception)new DefaultMuleException(this.mockMessage), expectedMessage);
    }

    @Test
    public void criticalNotHandled() throws Exception {
        this.flowRunner("propagatesCriticalErrors").runExpectingException(ErrorTypeMatcher.errorType((Matcher)Matchers.any(String.class), (Matcher)Is.is((Object)"CRITICAL")));
    }

    @Test
    public void innerRoutingErrorPropagated() throws Exception {
        ((FlowRunner)this.flowRunner("onErrorFails").withPayload((Object)"test")).runExpectingException(ErrorTypeMatcher.errorType((String)"MULE", (String)"EXPRESSION"));
    }

    @Test
    public void innerRoutingErrorHandled() throws Exception {
        Assert.assertThat((Object)((FlowRunner)this.flowRunner("propagatesErrorHandlingRoutingErrors").withPayload((Object)"test")).run().getMessage(), (Matcher)MessageMatchers.hasPayload((Matcher)Matchers.equalTo((Object)"test expression")));
    }

    private void callTypeAndThrowException(Exception exception, String expectedMessage) throws Exception {
        Message response = ((FlowRunner)((FlowRunner)this.flowRunner("matchesHandlerUsingType").withPayload((Object)"0")).withVariable("exception", (Object)exception)).run().getMessage();
        Assert.assertThat((Object)this.getPayloadAsString(response), (Matcher)Is.is((Object)expectedMessage));
    }

    private void callAndThrowException(Exception exceptionToThrow, String expectedMessage) throws Exception {
        this.callAndThrowException("0", exceptionToThrow, expectedMessage);
    }

    private void callAndThrowException(Object payload, Exception exceptionToThrow, String expectedMessage) throws Exception {
        FunctionalTestProcessor.getFromFlow((ConfigurationComponentLocator)this.locator, (String)"matchesHandlerUsingWhen").setEventCallback((context, component, muleContext) -> {
            throw exceptionToThrow;
        });
        Message response = ((FlowRunner)this.flowRunner("matchesHandlerUsingWhen").withPayload(payload)).run().getMessage();
        Assert.assertThat((Object)this.getPayloadAsString(response), (Matcher)Is.is((Object)expectedMessage));
    }

    public static class ThrowErrorProcessor
    implements Processor {
        public CoreEvent process(CoreEvent event) throws MuleException {
            throw new AssertionError((Object)"validation failed");
        }
    }

    public static class GenericMuleException
    extends MuleException {
        public GenericMuleException(I18nMessage message) {
            super(message);
        }

        public GenericMuleException(I18nMessage message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class AnotherTotallyDifferentKindOfException
    extends Exception {
    }

    public static class ThisExceptionFinishesWithSomethingElse
    extends Exception {
    }

    public static class ThisExceptionFinishesWithException
    extends Exception {
    }

    public static class StartsWithException
    extends Exception {
    }

    public static class AnotherTypeMyException
    extends Exception {
    }

    public static class SubtypeSubtypeException
    extends SubtypeException {
    }

    public static class SubtypeException
    extends BaseException {
    }

    public static class BaseException
    extends Exception {
    }
}

