/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.exceptions;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.extension.http.internal.temporary.HttpConnector;
import org.mule.extension.socket.api.SocketsExtension;
import org.mule.functional.junit4.matchers.ThrowableMessageMatcher;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.module.extension.api.loader.java.DefaultJavaExtensionModelLoader;
import org.mule.test.integration.AbstractConfigurationFailuresTestCase;

@Feature(value="Error Handling")
@Story(value="Validations")
public class ErrorHandlingConfigurationFailuresTestCase
extends AbstractConfigurationFailuresTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void errorHandlerCantHaveOnErrorWithoutTypeOrExpression() throws Exception {
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage(Matchers.containsString((String)"Every handler (except for the last one) within an 'error-handler' must specify a 'when' or 'type' attribute."));
        this.loadConfiguration("org/mule/test/integration/exceptions/exception-strategy-in-choice-without-expression.xml");
    }

    @Test
    public void onErrorReferenceMustHaveTypeOrExpression() throws Exception {
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage(Matchers.containsString((String)"Every handler (except for the last one) within an 'error-handler' must specify a 'when' or 'type' attribute."));
        this.loadConfiguration("org/mule/test/integration/exceptions/on-error-ref-without-matcher-config.xml");
    }

    @Test
    public void defaultErrorHandlerReferencesNonExistentErrorHandler() throws Exception {
        this.expectedException.expect(InitialisationException.class);
        this.expectedException.expectMessage(Matchers.containsString((String)"No global error handler defined with name 'nonExistentEh'."));
        this.loadConfiguration("org/mule/test/integration/exceptions/default-error-handler-reference-non-existent-es.xml");
    }

    @Test
    public void errorHandlerReferenceAndDefinitionNotAllowed() throws Exception {
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage(Matchers.containsString((String)"A reference error-handler cannot have on-errors."));
        this.loadConfiguration("org/mule/test/integration/exceptions/error-handler-reference-and-definition-config.xml");
    }

    @Test
    public void xaTransactionalTryNotAllowed() throws Exception {
        this.expectedException.expect(InitialisationException.class);
        this.expectedException.expectMessage(Matchers.containsString((String)"Unable to create Try Scope with a Transaction Type: [XA]"));
        this.loadConfiguration("org/mule/test/integration/transaction/xa-transactional-try-config.xml");
    }

    @Test
    public void unknownErrorFilteringNotAllowed() throws Exception {
        this.expectedException.expect(InitialisationException.class);
        this.expectedException.expectCause(ThrowableMessageMatcher.hasMessage((Matcher)Matchers.equalTo((Object)this.notFound("UNKNOWN"))));
        this.loadConfiguration("org/mule/test/integration/exceptions/unknown-error-filtering-config.xml");
    }

    @Test
    public void sourceErrorResponseFilteringNotAllowed() throws Exception {
        this.expectedException.expect(InitialisationException.class);
        this.expectedException.expectCause(ThrowableMessageMatcher.hasMessage((Matcher)Matchers.equalTo((Object)this.notFound("SOURCE"))));
        this.loadConfiguration("org/mule/test/integration/exceptions/source-error-response-filtering-config.xml");
    }

    @Test
    public void sourceErrorResponseSendFilteringNotAllowed() throws Exception {
        this.expectedException.expect(InitialisationException.class);
        this.expectedException.expectCause(ThrowableMessageMatcher.hasMessage((Matcher)Matchers.equalTo((Object)this.notFound("SOURCE_ERROR_RESPONSE_SEND"))));
        this.loadConfiguration("org/mule/test/integration/exceptions/source-error-response-send-filtering-config.xml");
    }

    @Test
    public void sourceErrorResponseGenerateFilteringNotAllowed() throws Exception {
        this.expectedException.expect(InitialisationException.class);
        this.expectedException.expectCause(ThrowableMessageMatcher.hasMessage((Matcher)Matchers.equalTo((Object)this.notFound("SOURCE_ERROR_RESPONSE_GENERATE"))));
        this.loadConfiguration("org/mule/test/integration/exceptions/source-error-response-generate-filtering-config.xml");
    }

    @Test
    public void criticalErrorFilteringNotAllowed() throws Exception {
        this.expectedException.expect(InitialisationException.class);
        this.expectedException.expectCause(ThrowableMessageMatcher.hasMessage((Matcher)Matchers.equalTo((Object)this.notFound("CRITICAL"))));
        this.loadConfiguration("org/mule/test/integration/exceptions/critical-error-filtering-config.xml");
    }

    @Test
    public void severalAnyMappingsNotAllowed() throws Exception {
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage(Matchers.containsString((String)"Only one mapping for 'ANY' or an empty source type is allowed."));
        this.loadConfiguration("org/mule/test/integration/exceptions/several-any-mappings-config.xml");
    }

    @Test
    public void nonExistingSourceMappingNotAllowed() throws Exception {
        this.expectedException.expect(InitialisationException.class);
        this.expectedException.expectMessage(Matchers.containsString((String)"Could not find error 'NON_EXISTING'."));
        this.loadConfiguration("org/mule/test/integration/exceptions/non-existing-source-mapping-config.xml");
    }

    @Test
    public void middleAnyMappingsNotAllowed() throws Exception {
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage(Matchers.containsString((String)"Only the last error mapping can have 'ANY' or an empty source type."));
        this.loadConfiguration("org/mule/test/integration/exceptions/middle-any-mapping-config.xml");
    }

    @Test
    public void repeatedMappingsNotAllowed() throws Exception {
        this.expectedException.expect(ConfigurationException.class);
        this.expectedException.expectMessage(Matchers.containsString((String)"Repeated source types are not allowed. Offending types are 'ROUTING', 'EXPRESSION'."));
        this.loadConfiguration("org/mule/test/integration/exceptions/repeated-mappings-config.xml");
    }

    @Test
    public void nonExistingCoreMappingsNotAllowed() throws Exception {
        this.expectedException.expect(InitialisationException.class);
        this.expectedException.expectMessage(Matchers.containsString((String)"There's no MULE error named 'NON_EXISTING'."));
        this.loadConfiguration("org/mule/test/integration/exceptions/non-existent-core-mapping-config.xml");
    }

    @Test
    public void usedNamespaceMappingsNotAllowed() throws Exception {
        this.expectedException.expect(InitialisationException.class);
        this.expectedException.expectMessage(Matchers.containsString((String)"Cannot use error type 'HTTP:NOT_FOUND': namespace already exists."));
        this.loadConfiguration("org/mule/test/integration/exceptions/used-namespace-mappings-config.xml");
    }

    @Test
    public void nonExistingCoreErrorCannotBeRaised() throws Exception {
        this.expectedException.expect(InitialisationException.class);
        this.expectedException.expectMessage(Matchers.containsString((String)"There's no MULE error named 'NONEXISTENT'."));
        this.loadConfiguration("org/mule/test/integration/exceptions/non-existent-core-raise-error-config.xml");
    }

    @Test
    public void usedNamespaceErrorCannotBeRaised() throws Exception {
        this.expectedException.expect(InitialisationException.class);
        this.expectedException.expectMessage(Matchers.containsString((String)"Cannot use error type 'HTTP:TIMEOUT': namespace already exists."));
        this.loadConfiguration("org/mule/test/integration/exceptions/used-namespace-raise-error-config.xml");
    }

    @Test
    public void sourceResponseGenerateOnErrorContinue() throws Exception {
        this.expectedException.expect(InitialisationException.class);
        this.expectedException.expectMessage(Matchers.equalTo((Object)this.notAllowed("SOURCE_RESPONSE_GENERATE")));
        this.loadConfiguration("org/mule/test/integration/exceptions/on-error-continue-response-generate.xml");
    }

    @Test
    public void sourceResponseSendOnErrorContinue() throws Exception {
        this.expectedException.expect(InitialisationException.class);
        this.expectedException.expectMessage(Matchers.equalTo((Object)this.notAllowed("SOURCE_RESPONSE_SEND")));
        this.loadConfiguration("org/mule/test/integration/exceptions/on-error-continue-response-send.xml");
    }

    @Test
    public void sourceResponseErrorOnErrorContinue() throws Exception {
        this.expectedException.expect(InitialisationException.class);
        this.expectedException.expectMessage(Matchers.equalTo((Object)this.notAllowed("SOURCE_RESPONSE")));
        this.loadConfiguration("org/mule/test/integration/exceptions/on-error-continue-response-error.xml");
    }

    @Test
    public void sourceErrorInListOnErrorContinue() throws Exception {
        this.expectedException.expect(InitialisationException.class);
        this.expectedException.expectMessage(Matchers.equalTo((Object)this.notAllowed("SOURCE_RESPONSE")));
        this.loadConfiguration("org/mule/test/integration/exceptions/on-error-continue-source-error-list.xml");
    }

    private String notFound(String type) {
        return String.format("Could not find ErrorType for the given identifier: '%s'", type);
    }

    private String notAllowed(String type) {
        return String.format("Source errors are not allowed in 'on-error-continue' handlers. Offending type is '%s'.", type);
    }

    @Override
    protected List<ExtensionModel> getRequiredExtensions() {
        ExtensionModel sockets = this.loadExtension(SocketsExtension.class, Collections.emptySet());
        ExtensionModel http = this.loadExtension(HttpConnector.class, Collections.singleton(sockets));
        return Arrays.asList(http, sockets);
    }

    @Override
    protected ExtensionModel loadExtension(Class extension, Set<ExtensionModel> deps) {
        DefaultJavaExtensionModelLoader loader = new DefaultJavaExtensionModelLoader();
        HashMap<String, String> ctx = new HashMap<String, String>();
        ctx.put("type", extension.getName());
        ctx.put("version", "1.0.0-SNAPSHOT");
        return loader.loadExtensionModel(Thread.currentThread().getContextClassLoader(), DslResolvingContext.getDefault(deps), ctx);
    }
}

