/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.exceptions;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.functional.api.component.TestConnectorQueueHandler;
import org.mule.functional.api.event.TestLegacyEventUtils;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.exception.FlowExceptionHandler;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.processor.FlowAssert;
import org.mule.test.AbstractIntegrationTestCase;

public class ExceptionHandlingTestCase
extends AbstractIntegrationTestCase {
    public static final String MESSAGE = "some message";
    private static final String ERROR_HANDLER_CLASSNAME = "org.mule.runtime.core.internal.exception.ErrorHandler";
    private static final String LOGGING_ERROR_HANDLER_CLASSNAME = "org.mule.runtime.core.internal.processor.LoggingExceptionHandler";
    private static FlowExceptionHandler effectiveMessagingExceptionHandler;
    private static CountDownLatch latch;
    private TestConnectorQueueHandler queueHandler;

    protected String getConfigFile() {
        return "org/mule/test/integration/exceptions/exception-handling-test.xml";
    }

    protected void doSetUp() throws Exception {
        this.queueHandler = new TestConnectorQueueHandler(this.registry);
    }

    @After
    public void after() {
        effectiveMessagingExceptionHandler = null;
    }

    @Test
    public void testCustomProcessorInFlow() throws Exception {
        CoreEvent muleEvent = this.runFlow("customProcessorInFlow");
        Message response = muleEvent.getMessage();
        Assert.assertThat((Object)response, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)effectiveMessagingExceptionHandler.getClass().getName(), (Matcher)Matchers.equalTo((Object)ERROR_HANDLER_CLASSNAME));
        Assert.assertThat((Object)MuleTestUtils.getExceptionListeners((FlowExceptionHandler)effectiveMessagingExceptionHandler), (Matcher)Matchers.hasSize((int)2));
        FlowExceptionHandler handler = (FlowExceptionHandler)MuleTestUtils.getExceptionListeners((FlowExceptionHandler)effectiveMessagingExceptionHandler).get(1);
        Assert.assertThat((Object)handler.getClass().getName(), (Matcher)Matchers.equalTo((Object)"org.mule.runtime.core.internal.exception.OnErrorPropagateHandler"));
    }

    @Test
    public void testAsyncInFlow() throws Exception {
        ((FlowRunner)this.flowRunner("asyncInFlow").withPayload((Object)MESSAGE)).dispatch();
        Message response = this.queueHandler.read("outFlow4", 3000L).getMessage();
        Assert.assertNotNull((Object)response);
        Assert.assertThat((Object)effectiveMessagingExceptionHandler.getClass().getName(), (Matcher)Matchers.equalTo((Object)ERROR_HANDLER_CLASSNAME));
    }

    @Test
    public void testUntilSuccessfulInFlow() throws Exception {
        ((FlowRunner)this.flowRunner("untilSuccessfulInFlow").withPayload((Object)MESSAGE)).dispatch();
        Message response = this.queueHandler.read("outFlow5", 3000L).getMessage();
        Assert.assertNotNull((Object)response);
        Assert.assertThat((Object)effectiveMessagingExceptionHandler.getClass().getName(), (Matcher)Matchers.equalTo((Object)ERROR_HANDLER_CLASSNAME));
    }

    @Test
    public void testCustomProcessorInScope() throws Exception {
        LinkedList<String> list = new LinkedList<String>();
        list.add(MESSAGE);
        CoreEvent muleEvent = ((FlowRunner)this.flowRunner("customProcessorInScope").withPayload(list)).run();
        Message response = muleEvent.getMessage();
        Assert.assertNotNull((Object)response);
        Assert.assertThat((Object)effectiveMessagingExceptionHandler.getClass().getName(), (Matcher)Matchers.equalTo((Object)ERROR_HANDLER_CLASSNAME));
    }

    @Test
    public void testCustomProcessorInTransactionalScope() throws Exception {
        ((FlowRunner)this.flowRunner("customProcessorInTransactionalScope").withPayload((Object)MESSAGE)).dispatch();
        Message response = this.queueHandler.read("outTransactional1", 3000L).getMessage();
        Assert.assertNotNull((Object)response);
        FlowAssert.verify((String)"customProcessorInTransactionalScope");
        Assert.assertThat((Object)effectiveMessagingExceptionHandler.getClass().getName(), (Matcher)Matchers.equalTo((Object)ERROR_HANDLER_CLASSNAME));
    }

    @Test
    public void testUntilSuccessfulInTransactionalScope() throws Exception {
        this.testTransactionalScope("untilSuccessfulInTransactionalScope", "outTransactional5", Collections.emptyMap());
        Assert.assertThat((Object)effectiveMessagingExceptionHandler.getClass().getName(), (Matcher)Matchers.equalTo((Object)ERROR_HANDLER_CLASSNAME));
    }

    @Test
    public void testCustomProcessorInExceptionStrategy() throws Exception {
        ((FlowRunner)this.flowRunner("customProcessorInExceptionStrategy").withPayload((Object)MESSAGE)).dispatch();
        Message response = this.queueHandler.read("outStrategy1", 3000L).getMessage();
        Assert.assertNotNull((Object)response);
        FlowAssert.verify((String)"customProcessorInExceptionStrategy");
        Assert.assertThat((Object)effectiveMessagingExceptionHandler.getClass().getName(), (Matcher)Matchers.equalTo((Object)ERROR_HANDLER_CLASSNAME));
    }

    @Test
    public void testAsyncInExceptionStrategy() throws Exception {
        this.testExceptionStrategy("asyncInExceptionStrategy", Collections.emptyMap());
        Assert.assertThat((Object)effectiveMessagingExceptionHandler.getClass().getName(), (Matcher)Matchers.equalTo((Object)LOGGING_ERROR_HANDLER_CLASSNAME));
    }

    @Test
    public void testUntilSuccessfulInExceptionStrategy() throws Exception {
        this.testExceptionStrategy("untilSuccessfulInExceptionStrategy", Collections.emptyMap());
        Assert.assertThat((Object)effectiveMessagingExceptionHandler.getClass().getName(), (Matcher)Matchers.equalTo((Object)ERROR_HANDLER_CLASSNAME));
    }

    @Test
    public void testUntilSuccessfulInExceptionStrategyRollback() throws Exception {
        this.testExceptionStrategy("untilSuccessfulInExceptionStrategyRollback", Collections.emptyMap());
        Assert.assertThat((Object)effectiveMessagingExceptionHandler.getClass().getName(), (Matcher)Matchers.equalTo((Object)ERROR_HANDLER_CLASSNAME));
    }

    @Test
    public void errorThrownByOperationInForeach() throws Exception {
        Exception eventProcessingException = ((FlowRunner)this.flowRunner("errorThrownByOperationInForeach").withPayload(Arrays.asList("1", "2", "3"))).runExpectingException();
        Assert.assertThat((Object)eventProcessingException.getCause(), (Matcher)Matchers.instanceOf(ExpressionRuntimeException.class));
    }

    private void testTransactionalScope(String flowName, String expected, Map<String, Serializable> messageProperties) throws Exception {
        ((FlowRunner)((FlowRunner)this.flowRunner(flowName).withPayload((Object)MESSAGE)).withInboundProperties(messageProperties)).dispatch();
        Message response = this.queueHandler.read(expected, 3000L).getMessage();
        Assert.assertNotNull((Object)response);
    }

    private void testExceptionStrategy(String flowName, Map<String, Serializable> messageProperties) throws Exception {
        latch = (CountDownLatch)Mockito.spy((Object)new CountDownLatch(2));
        try {
            ((FlowRunner)((FlowRunner)this.flowRunner(flowName).withPayload((Object)MESSAGE)).withInboundProperties(messageProperties)).dispatch();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertFalse((boolean)latch.await(3L, TimeUnit.SECONDS));
        ((CountDownLatch)Mockito.verify((Object)latch)).countDown();
    }

    public static class ExceptionHandlerVerifierProcessor
    implements Processor {
        public synchronized CoreEvent process(CoreEvent event) throws MuleException {
            effectiveMessagingExceptionHandler = TestLegacyEventUtils.getEffectiveExceptionHandler((CoreEvent)event);
            return event;
        }
    }

    public static class ExecutionCountProcessor
    implements Processor {
        public synchronized CoreEvent process(CoreEvent event) throws MuleException {
            latch.countDown();
            return event;
        }
    }
}

