/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.exceptions;

import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.transaction.Transaction;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.test.AbstractIntegrationTestCase;

public class OnErrorContinueFlowRefTestCase
extends AbstractIntegrationTestCase {
    public static final int TIMEOUT = 5000;

    protected String getConfigFile() {
        return "org/mule/test/integration/exceptions/on-error-continue-flow-ref.xml";
    }

    @Test
    public void testFlowRefHandlingException() throws Exception {
        Message response = ((FlowRunner)this.flowRunner("exceptionHandlingBlock").withPayload((Object)"{\"userId\":\"15\"}")).run().getMessage();
        ObjectMapper mapper = new ObjectMapper();
        JsonNode actualJsonNode = mapper.readTree(this.getPayloadAsString(response));
        JsonNode expectedJsonNode = mapper.readTree("{\"errorMessage\":\"error processing news\",\"userId\":15,\"title\":\"News title\"}");
        Assert.assertThat((Object)actualJsonNode, (Matcher)Is.is((Object)expectedJsonNode));
    }

    @Test
    public void testFlowRefHandlingExceptionWithTransaction() throws Exception {
        Message response = ((FlowRunner)this.flowRunner("transactionNotResolvedAfterException").withPayload((Object)"{\"userId\":\"15\"}")).run().getMessage();
        ObjectMapper mapper = new ObjectMapper();
        JsonNode actualJsonNode = mapper.readTree(this.getPayloadAsString(response));
        JsonNode expectedJsonNode = mapper.readTree("{\"errorMessage\":\"error processing news\",\"userId\":15,\"title\":\"News title\"}");
        Assert.assertThat((Object)actualJsonNode, (Matcher)Is.is((Object)expectedJsonNode));
    }

    public static class VerifyTransactionNotResolvedProcessor
    implements Processor {
        public CoreEvent process(CoreEvent event) throws MuleException {
            Transaction tx = TransactionCoordination.getInstance().getTransaction();
            Assert.assertThat((Object)tx, (Matcher)IsNull.notNullValue());
            Assert.assertThat((Object)tx.isRollbackOnly(), (Matcher)Is.is((Object)false));
            return event;
        }
    }
}

