/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.exceptions;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.functional.junit4.matchers.MessageMatchers;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.tck.junit4.matcher.EventMatcher;
import org.mule.test.AbstractIntegrationTestCase;

@Feature(value="Error Handling")
@Story(value="On Error Nested Exceptions")
public class OnErrorNestedExceptionsTestCase
extends AbstractIntegrationTestCase {
    protected String getConfigFile() {
        return "org/mule/test/integration/exceptions/on-error-nested-exceptions-config.xml";
    }

    @Test
    public void propagatesToOuterWithoutExceptionAndSucceeds() throws Exception {
        CoreEvent event = this.flowRunner("propagatesToOuterWithoutExceptionAndSucceeds").run();
        Assert.assertThat((Object)event.getMessage(), (Matcher)MessageMatchers.hasPayload((Matcher)CoreMatchers.equalTo((Object)"propagated again")));
    }

    @Test
    public void propagatesToOuterWithoutExceptionAndFails() throws Exception {
        this.flowRunner("propagatesToOuterWithoutExceptionAndFails").runExpectingException(EventMatcher.hasMessage((Matcher)MessageMatchers.hasPayload((Matcher)CoreMatchers.equalTo((Object)"propagated again"))));
    }

    @Test
    public void propagatesToFlowWithoutExceptionAndSucceeds() throws Exception {
        CoreEvent event = this.flowRunner("propagatesToFlowWithoutExceptionAndSucceeds").run();
        Assert.assertThat((Object)event.getMessage(), (Matcher)MessageMatchers.hasPayload((Matcher)CoreMatchers.equalTo((Object)"propagated again")));
    }

    @Test
    public void propagatesToFlowWithoutExceptionAndFails() throws Exception {
        this.flowRunner("propagatesToFlowWithoutExceptionAndFails").runExpectingException(EventMatcher.hasMessage((Matcher)MessageMatchers.hasPayload((Matcher)CoreMatchers.equalTo((Object)"propagated again"))));
    }

    @Test
    public void propagatesToOuterWithExceptionAndSucceeds() throws Exception {
        CoreEvent event = this.flowRunner("propagatesToOuterWithExceptionAndSucceeds").run();
        Assert.assertThat((Object)event.getMessage(), (Matcher)MessageMatchers.hasPayload((Matcher)CoreMatchers.equalTo((Object)"propagated again")));
    }

    @Test
    public void propagatesToOuterWithExceptionAndFails() throws Exception {
        this.flowRunner("propagatesToOuterWithExceptionAndFails").runExpectingException(EventMatcher.hasMessage((Matcher)MessageMatchers.hasPayload((Matcher)CoreMatchers.equalTo((Object)"propagated again"))));
    }

    @Test
    public void propagatesToFlowWithExceptionAndSucceeds() throws Exception {
        CoreEvent event = this.flowRunner("propagatesToFlowWithExceptionAndSucceeds").run();
        Assert.assertThat((Object)event.getMessage(), (Matcher)MessageMatchers.hasPayload((Matcher)CoreMatchers.equalTo((Object)"propagated again")));
    }

    @Test
    public void propagatesToFlowWithExceptionAndFails() throws Exception {
        this.flowRunner("propagatesToFlowWithExceptionAndFails").runExpectingException(EventMatcher.hasMessage((Matcher)MessageMatchers.hasPayload((Matcher)CoreMatchers.equalTo((Object)"propagated again"))));
    }

    @Test
    public void exceptionInErrorHandlerFlowIsMarked() throws Exception {
        this.flowRunner("exceptionInErrorHandlerFlow").runExpectingException(EventMatcher.hasMessage((Matcher)MessageMatchers.hasPayload((Matcher)CoreMatchers.equalTo((Object)"propagated"))));
    }

    @Test
    public void exceptionInErrorHandlerTryIsMarked() throws Exception {
        this.flowRunner("exceptionInErrorHandlerTry").runExpectingException(EventMatcher.hasMessage((Matcher)MessageMatchers.hasPayload((Matcher)CoreMatchers.equalTo((Object)"propagated"))));
    }

    @Test
    public void exceptionInErrorHandlerNestedTryIsMarked() throws Exception {
        this.flowRunner("exceptionInErrorHandlerNestedTry").runExpectingException(EventMatcher.hasMessage((Matcher)MessageMatchers.hasPayload((Matcher)CoreMatchers.equalTo((Object)"propagated"))));
    }
}

