/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.exceptions;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsMapContaining;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.functional.api.component.TestConnectorQueueHandler;
import org.mule.functional.api.exception.ExpectedError;
import org.mule.functional.api.exception.FunctionalTestException;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.functional.junit4.matchers.MessageMatchers;
import org.mule.functional.junit4.matchers.ThrowableCauseMatcher;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleFatalException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.service.http.TestHttpClient;
import org.mule.tck.junit4.matcher.EventMatcher;
import org.mule.tck.junit4.matcher.HasClassInHierarchy;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.test.AbstractIntegrationTestCase;

@Feature(value="Error Handling")
@Story(value="On Error Propagate")
public class OnErrorPropagateTestCase
extends AbstractIntegrationTestCase {
    private TestConnectorQueueHandler queueHandler;
    @Rule
    public ExpectedError expectedError = ExpectedError.none();
    @Rule
    public DynamicPort port = new DynamicPort("port");
    @Rule
    public TestHttpClient httpClient = new TestHttpClient.Builder((HttpService)this.getService(HttpService.class)).build();

    protected String getConfigFile() {
        return "org/mule/test/integration/exceptions/on-error-propagate-use-case-config.xml";
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.queueHandler = new TestConnectorQueueHandler(this.registry);
    }

    @Test
    public void typeMatch() throws Exception {
        this.verifyFlow("onErrorPropagateTypeMatch");
        CoreEvent customPath = this.queueHandler.read("custom1", 5000L);
        Assert.assertThat((Object)customPath, (Matcher)Is.is((Matcher)CoreMatchers.nullValue()));
        CoreEvent anyPath = this.queueHandler.read("any1", 5000L);
        Assert.assertThat((Object)anyPath, (Matcher)Is.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void typeMatchAny() throws Exception {
        this.verifyFlow("onErrorPropagateTypeMatchAny");
        CoreEvent customPath = this.queueHandler.read("custom2", 5000L);
        Assert.assertThat((Object)customPath, (Matcher)Is.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void typeMatchSeveral() throws Exception {
        this.verifyFlow("onErrorPropagateTypeMatchSeveral", true);
        CoreEvent anyPath = this.queueHandler.read("any", 5000L);
        Assert.assertThat((Object)anyPath, (Matcher)Is.is((Matcher)CoreMatchers.nullValue()));
        this.verifyFlow("onErrorPropagateTypeMatchSeveral", false);
        anyPath = this.queueHandler.read("any", 5000L);
        Assert.assertThat((Object)anyPath, (Matcher)Is.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void propagateErrorAndMessage() throws Exception {
        this.expectedError.expectCause(HasClassInHierarchy.withClassName((String)"org.mule.runtime.api.exception.DefaultMuleException"));
        Matcher hasEntry = IsMapContaining.hasEntry((Object)"myVar", (Object)new TypedValue((Object)"aValue", DataType.builder().type(String.class).mediaType(MediaType.TEXT).charset(StandardCharsets.UTF_8).build()));
        this.expectedError.expectEvent(Matchers.allOf((Matcher)EventMatcher.hasVariables((Matcher)hasEntry), (Matcher)EventMatcher.hasMessage((Matcher)MessageMatchers.hasPayload((Matcher)CoreMatchers.equalTo((Object)"propagated")))));
        this.flowRunner("onErrorPropagateMessage").run();
    }

    @Test
    public void onErrorPropagateFailure() throws Exception {
        this.expectedError.expectCause(CoreMatchers.instanceOf(MuleFatalException.class));
        this.expectedError.expectCause(ThrowableCauseMatcher.hasCause((Matcher)CoreMatchers.instanceOf(NoClassDefFoundError.class)));
        this.flowRunner("failingHandler").run();
    }

    @Test
    public void handlesSourceErrors() throws Exception {
        HttpRequest request = ((HttpRequestBuilder)HttpRequest.builder().uri(this.getUrl()).method(HttpConstants.Method.POST).entity((HttpEntity)new ByteArrayHttpEntity("Test Message".getBytes()))).build();
        HttpResponse response = this.httpClient.send(request, 5000, false, null);
        Assert.assertThat((Object)response.getStatusCode(), (Matcher)Is.is((Object)HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR.getStatusCode()));
        Assert.assertThat((Object)this.queueHandler.read("out", 5000L).getMessage(), (Matcher)MessageMatchers.hasPayload((Matcher)CoreMatchers.equalTo((Object)"Test Message hey")));
    }

    private String getUrl() {
        return String.format("http://localhost:%s/sourceError", this.port.getNumber());
    }

    private void verifyFlow(String flowName, Object payload) throws InterruptedException {
        block2: {
            try {
                ((FlowRunner)this.flowRunner(flowName).withPayload(payload)).dispatch();
            }
            catch (Exception e) {
                Assert.assertThat((Object)e.getCause(), (Matcher)Is.is((Matcher)CoreMatchers.instanceOf(FunctionalTestException.class)));
                if (CallMessageProcessor.latch.await(5000L, TimeUnit.MILLISECONDS)) break block2;
                Assert.fail((String)"custom message processor wasn't call");
            }
        }
    }

    private void verifyFlow(String flowName) throws InterruptedException {
        this.verifyFlow(flowName, "Test Message");
    }

    public static class CallMessageProcessor
    implements Processor {
        public static Latch latch = new Latch();

        public CoreEvent process(CoreEvent event) throws MuleException {
            latch.release();
            return event;
        }
    }

    public static class ErrorProcessor
    implements Processor {
        public CoreEvent process(CoreEvent event) throws MuleException {
            throw new NoClassDefFoundError("Test error");
        }
    }
}

