/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.exceptions;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.functional.api.component.TestConnectorQueueHandler;
import org.mule.functional.api.exception.ExpectedError;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.service.http.TestHttpClient;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.test.AbstractIntegrationTestCase;

@Feature(value="Error Handling")
@Story(value="Redelivery Exceeded")
public class RedeliveryExhaustedTestCase
extends AbstractIntegrationTestCase {
    private static final int MAX_REDELIVERY_COUNT = 2;
    private TestConnectorQueueHandler queueHandler;
    @Rule
    public ExpectedError expectedError = ExpectedError.none();
    @Rule
    public DynamicPort port = new DynamicPort("port");
    @Rule
    public SystemProperty maxRedeliveryCount = new SystemProperty("maxRedeliveryCount", "2");
    @Rule
    public TestHttpClient httpClient = new TestHttpClient.Builder((HttpService)this.getService(HttpService.class)).build();

    protected String getConfigFile() {
        return "org/mule/test/integration/exceptions/redelivery-exhausted.xml";
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.queueHandler = new TestConnectorQueueHandler(this.registry);
    }

    @Test
    @Description(value="Test that the required troubleshooting information is in the redelivery error.")
    public void exhaustRedelivery() throws IOException, TimeoutException {
        for (int i = 0; i < 3; ++i) {
            Assert.assertThat((Object)this.sendThroughHttp().getStatusCode(), (Matcher)Is.is((Object)HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR.getStatusCode()));
        }
        HttpResponse response = this.sendThroughHttp();
        Assert.assertThat((Object)response.getStatusCode(), (Matcher)Is.is((Object)HttpConstants.HttpStatus.SERVICE_UNAVAILABLE.getStatusCode()));
        CoreEvent event = this.queueHandler.read("out", 5000L);
        Error error = (Error)event.getMessage().getPayload().getValue();
        Assert.assertThat((Object)error.getErrorType().getIdentifier(), (Matcher)Is.is((Object)"REDELIVERY_EXHAUSTED"));
        Assert.assertThat((Object)error.getChildErrors(), (Matcher)Matchers.hasSize((int)3));
        for (Error childError : error.getChildErrors()) {
            Assert.assertThat((Object)childError.getErrorType().getIdentifier(), (Matcher)Is.is((Object)"ROUTING"));
        }
    }

    private HttpResponse sendThroughHttp() throws IOException, TimeoutException {
        HttpRequest request = ((HttpRequestBuilder)HttpRequest.builder().uri(this.getUrl()).method(HttpConstants.Method.POST).entity((HttpEntity)new ByteArrayHttpEntity("Test Message".getBytes()))).build();
        return this.httpClient.send(request, 5000, false, null);
    }

    private String getUrl() {
        return String.format("http://localhost:%s/exhaustRedelivery", this.port.getNumber());
    }
}

