/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.interception;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.functional.api.exception.ExpectedError;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.interception.InterceptionAction;
import org.mule.runtime.api.interception.InterceptionEvent;
import org.mule.runtime.api.interception.ProcessorInterceptor;
import org.mule.runtime.api.interception.ProcessorInterceptorFactory;
import org.mule.runtime.api.interception.ProcessorParameterValue;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.test.heisenberg.extension.HeisenbergConnection;
import org.mule.test.heisenberg.extension.HeisenbergConnectionProvider;
import org.mule.test.integration.interception.ProcessorInterceptorFactoryTestCase;
import org.mule.test.runner.RunnerDelegateTo;

@Feature(value="Interception API")
@Story(value="Component Interception Story")
@RunnerDelegateTo(value=Parameterized.class)
public class ProcessorInterceptorFactoryCustomActionTestCase
extends AbstractIntegrationTestCase {
    @Rule
    public ExpectedError expectedError = ExpectedError.none();
    private final boolean mutateEventBefore;

    public ProcessorInterceptorFactoryCustomActionTestCase(boolean mutateEventBefore) {
        this.mutateEventBefore = mutateEventBefore;
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object> data() {
        return Arrays.asList(true, false);
    }

    protected String getConfigFile() {
        return "org/mule/test/integration/interception/processor-interceptor-factory.xml";
    }

    protected Map<String, Object> getStartUpRegistryObjects() {
        HashMap<String, Object> objects = new HashMap<String, Object>();
        objects.put("_CustomActionInterceptorFactory", new CustomActionInterceptorFactory());
        objects.put("_HasInjectedAttributesInterceptorFactory", new ProcessorInterceptorFactoryTestCase.HasInjectedAttributesInterceptorFactory(this.mutateEventBefore));
        objects.put("_muleProcessorInterceptorFactoryOrder", () -> Arrays.asList(CustomActionInterceptorFactory.class.getName(), ProcessorInterceptorFactoryTestCase.HasInjectedAttributesInterceptorFactory.class.getName()));
        return objects;
    }

    @Before
    public void before() {
        CustomActionInterceptor.actioner = action -> action.proceed();
    }

    @After
    public void after() {
        HeisenbergConnectionProvider.getActiveConnections().clear();
        ProcessorInterceptorFactoryTestCase.HasInjectedAttributesInterceptor.interceptionParameters.clear();
    }

    @Test
    @Description(value="The connection was fetched on the interceptor, and released by the interceptor")
    public void resolvedConnectionParamSkips() throws Exception {
        int connectsBefore = HeisenbergConnectionProvider.getConnects();
        int disconnectsBefore = HeisenbergConnectionProvider.getDisconnects();
        CustomActionInterceptor.actioner = action -> action.skip();
        this.flowRunner("callSaul").run();
        List<ProcessorInterceptorFactoryTestCase.InterceptionParameters> interceptionParameters = ProcessorInterceptorFactoryTestCase.HasInjectedAttributesInterceptor.interceptionParameters;
        Assert.assertThat(interceptionParameters, (Matcher)Matchers.hasSize((int)1));
        ProcessorInterceptorFactoryTestCase.InterceptionParameters killInterceptionParameter = interceptionParameters.get(0);
        Assert.assertThat(killInterceptionParameter.getParameters().keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"targetValue", "config-ref", "connection"}));
        Assert.assertThat((Object)killInterceptionParameter.getParameters().get("config-ref").resolveValue(), (Matcher)Matchers.is((Object)"heisenberg"));
        Assert.assertThat((Object)killInterceptionParameter.getParameters().get("connection").resolveValue(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(HeisenbergConnection.class)));
        Assert.assertThat((Object)HeisenbergConnectionProvider.getActiveConnections(), (Matcher)Matchers.empty());
        Assert.assertThat((Object)(HeisenbergConnectionProvider.getConnects() - connectsBefore), (Matcher)Matchers.is((Object)(this.mutateEventBefore ? 2 : 1)));
        Assert.assertThat((Object)(HeisenbergConnectionProvider.getDisconnects() - disconnectsBefore), (Matcher)Matchers.is((Object)(this.mutateEventBefore ? 2 : 1)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Description(value="The connection was fetched on the interceptor, and released by the interceptor")
    public void resolvedConnectionParamFails() throws Exception {
        List<ProcessorInterceptorFactoryTestCase.InterceptionParameters> interceptionParameters2;
        int connectsBefore = HeisenbergConnectionProvider.getConnects();
        int disconnectsBefore = HeisenbergConnectionProvider.getDisconnects();
        CustomActionInterceptor.actioner = action -> action.fail((Throwable)new RuntimeException());
        try {
            this.flowRunner("callSaul").run();
            Assert.fail((String)"Expected an exception. Refer to ReactiveInterceptorAdapterTestCase");
            interceptionParameters2 = ProcessorInterceptorFactoryTestCase.HasInjectedAttributesInterceptor.interceptionParameters;
        }
        catch (Exception interceptionParameters2) {
            List<ProcessorInterceptorFactoryTestCase.InterceptionParameters> interceptionParameters3 = ProcessorInterceptorFactoryTestCase.HasInjectedAttributesInterceptor.interceptionParameters;
            Assert.assertThat(interceptionParameters3, (Matcher)Matchers.hasSize((int)2));
            ProcessorInterceptorFactoryTestCase.InterceptionParameters killInterceptionParameter = interceptionParameters3.get(0);
            Assert.assertThat(killInterceptionParameter.getParameters().keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"targetValue", "config-ref", "connection"}));
            Assert.assertThat((Object)killInterceptionParameter.getParameters().get("config-ref").resolveValue(), (Matcher)Matchers.is((Object)"heisenberg"));
            Assert.assertThat((Object)killInterceptionParameter.getParameters().get("connection").resolveValue(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(HeisenbergConnection.class)));
            Assert.assertThat((Object)HeisenbergConnectionProvider.getActiveConnections(), (Matcher)Matchers.empty());
            Assert.assertThat((Object)(HeisenbergConnectionProvider.getConnects() - connectsBefore), (Matcher)Matchers.is((Object)(this.mutateEventBefore ? 2 : 1)));
            Assert.assertThat((Object)(HeisenbergConnectionProvider.getDisconnects() - disconnectsBefore), (Matcher)Matchers.is((Object)(this.mutateEventBefore ? 2 : 1)));
        }
        catch (Throwable throwable) {
            List<ProcessorInterceptorFactoryTestCase.InterceptionParameters> interceptionParameters4 = ProcessorInterceptorFactoryTestCase.HasInjectedAttributesInterceptor.interceptionParameters;
            Assert.assertThat(interceptionParameters4, (Matcher)Matchers.hasSize((int)2));
            ProcessorInterceptorFactoryTestCase.InterceptionParameters killInterceptionParameter = interceptionParameters4.get(0);
            Assert.assertThat(killInterceptionParameter.getParameters().keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"targetValue", "config-ref", "connection"}));
            Assert.assertThat((Object)killInterceptionParameter.getParameters().get("config-ref").resolveValue(), (Matcher)Matchers.is((Object)"heisenberg"));
            Assert.assertThat((Object)killInterceptionParameter.getParameters().get("connection").resolveValue(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(HeisenbergConnection.class)));
            Assert.assertThat((Object)HeisenbergConnectionProvider.getActiveConnections(), (Matcher)Matchers.empty());
            Assert.assertThat((Object)(HeisenbergConnectionProvider.getConnects() - connectsBefore), (Matcher)Matchers.is((Object)(this.mutateEventBefore ? 2 : 1)));
            Assert.assertThat((Object)(HeisenbergConnectionProvider.getDisconnects() - disconnectsBefore), (Matcher)Matchers.is((Object)(this.mutateEventBefore ? 2 : 1)));
            throw throwable;
        }
        Assert.assertThat(interceptionParameters2, (Matcher)Matchers.hasSize((int)2));
        ProcessorInterceptorFactoryTestCase.InterceptionParameters killInterceptionParameter = interceptionParameters2.get(0);
        Assert.assertThat(killInterceptionParameter.getParameters().keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"targetValue", "config-ref", "connection"}));
        Assert.assertThat((Object)killInterceptionParameter.getParameters().get("config-ref").resolveValue(), (Matcher)Matchers.is((Object)"heisenberg"));
        Assert.assertThat((Object)killInterceptionParameter.getParameters().get("connection").resolveValue(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(HeisenbergConnection.class)));
        Assert.assertThat((Object)HeisenbergConnectionProvider.getActiveConnections(), (Matcher)Matchers.empty());
        Assert.assertThat((Object)(HeisenbergConnectionProvider.getConnects() - connectsBefore), (Matcher)Matchers.is((Object)(this.mutateEventBefore ? 2 : 1)));
        Assert.assertThat((Object)(HeisenbergConnectionProvider.getDisconnects() - disconnectsBefore), (Matcher)Matchers.is((Object)(this.mutateEventBefore ? 2 : 1)));
    }

    @Test
    @Description(value="The connection was fetched on the interceptor, and the operation uses the connection obtained there rather then fetching it again")
    public void resolvedConnectionParam() throws Exception {
        int connectsBefore = HeisenbergConnectionProvider.getConnects();
        int disconnectsBefore = HeisenbergConnectionProvider.getDisconnects();
        this.flowRunner("callSaul").run();
        List<ProcessorInterceptorFactoryTestCase.InterceptionParameters> interceptionParameters = ProcessorInterceptorFactoryTestCase.HasInjectedAttributesInterceptor.interceptionParameters;
        Assert.assertThat(interceptionParameters, (Matcher)Matchers.hasSize((int)1));
        ProcessorInterceptorFactoryTestCase.InterceptionParameters killInterceptionParameter = interceptionParameters.get(0);
        Assert.assertThat(killInterceptionParameter.getParameters().keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"targetValue", "config-ref", "connection"}));
        Assert.assertThat((Object)killInterceptionParameter.getParameters().get("config-ref").resolveValue(), (Matcher)Matchers.is((Object)"heisenberg"));
        Assert.assertThat((Object)killInterceptionParameter.getParameters().get("connection").resolveValue(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(HeisenbergConnection.class)));
        Assert.assertThat((Object)HeisenbergConnectionProvider.getActiveConnections(), (Matcher)Matchers.empty());
        Assert.assertThat((Object)(HeisenbergConnectionProvider.getConnects() - connectsBefore), (Matcher)Matchers.is((Object)(this.mutateEventBefore ? 2 : 1)));
        Assert.assertThat((Object)(HeisenbergConnectionProvider.getDisconnects() - disconnectsBefore), (Matcher)Matchers.is((Object)(this.mutateEventBefore ? 2 : 1)));
    }

    public static class CustomActionInterceptor
    implements ProcessorInterceptor {
        private static Function<InterceptionAction, CompletableFuture<InterceptionEvent>> actioner = action -> action.proceed();

        public CompletableFuture<InterceptionEvent> around(ComponentLocation location, Map<String, ProcessorParameterValue> parameters, InterceptionEvent event, InterceptionAction action) {
            return actioner.apply(action);
        }
    }

    public static class CustomActionInterceptorFactory
    implements ProcessorInterceptorFactory {
        public ProcessorInterceptor get() {
            return new CustomActionInterceptor();
        }
    }
}

