/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.interception;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsMapContaining;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.interception.InterceptionEvent;
import org.mule.runtime.api.interception.ProcessorParameterValue;
import org.mule.runtime.api.interception.SourceInterceptor;
import org.mule.runtime.api.interception.SourceInterceptorFactory;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.test.heisenberg.extension.HeisenbergConnectionProvider;
import org.mule.test.heisenberg.extension.HeisenbergSource;
import org.mule.test.integration.interception.ProcessorInterceptorFactoryTestCase;

@Feature(value="Interception API")
@Story(value="Component Interception Story")
public class SourceInterceptorFactoryTestCase
extends AbstractIntegrationTestCase {
    private Flow flow;

    protected String getConfigFile() {
        return "org/mule/test/integration/interception/source-interceptor-factory.xml";
    }

    protected Map<String, Object> getStartUpRegistryObjects() {
        HashMap<String, Object> objects = new HashMap<String, Object>();
        objects.put("_SourceCallbackInterceptor", new SourceCallbackInterceptorFactory());
        return objects;
    }

    @After
    public void after() throws MuleException {
        if (this.flow != null) {
            this.flow.stop();
        }
        HeisenbergConnectionProvider.getActiveConnections().clear();
        SourceCallbackInterceptor.interceptionParameters.clear();
        SourceCallbackInterceptor.afterCallback = (event, thrown) -> {};
        HeisenbergSource.resetHeisenbergSource();
    }

    @Test
    public void sourceIntercepted() throws Exception {
        this.startFlow("sourceIntercepted");
        CountDownLatch afterCalledLatch = new CountDownLatch(1);
        SourceCallbackInterceptor.afterCallback = (event, thrown) -> {
            if (!thrown.isPresent()) {
                afterCalledLatch.countDown();
            }
        };
        Assert.assertThat((Object)afterCalledLatch.await(5000L, TimeUnit.MILLISECONDS), (Matcher)Matchers.is((Object)true));
        List<ProcessorInterceptorFactoryTestCase.InterceptionParameters> interceptionParameters = SourceCallbackInterceptor.interceptionParameters;
        Assert.assertThat(interceptionParameters, (Matcher)Matchers.hasSize((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1))));
        ProcessorInterceptorFactoryTestCase.InterceptionParameters heisenbergSourceInterceptionParameter = interceptionParameters.get(0);
        Assert.assertThat(heisenbergSourceInterceptionParameter.getParameters().entrySet(), (Matcher)Matchers.hasSize((int)8));
        Assert.assertThat(heisenbergSourceInterceptionParameter.getParameters(), (Matcher)IsMapContaining.hasKey((Object)"fail"));
        Assert.assertThat(heisenbergSourceInterceptionParameter.getParameters(), (Matcher)IsMapContaining.hasKey((Object)"config-ref"));
        Assert.assertThat(heisenbergSourceInterceptionParameter.getParameters(), (Matcher)IsMapContaining.hasKey((Object)"initialBatchNumber"));
        Assert.assertThat(heisenbergSourceInterceptionParameter.getParameters(), (Matcher)IsMapContaining.hasKey((Object)"payment"));
        Assert.assertThat(heisenbergSourceInterceptionParameter.getParameters(), (Matcher)IsMapContaining.hasKey((Object)"frequency"));
        Assert.assertThat(heisenbergSourceInterceptionParameter.getParameters(), (Matcher)IsMapContaining.hasKey((Object)"propagateError"));
        Assert.assertThat(heisenbergSourceInterceptionParameter.getParameters(), (Matcher)IsMapContaining.hasKey((Object)"corePoolSize"));
        Assert.assertThat(heisenbergSourceInterceptionParameter.getParameters(), (Matcher)IsMapContaining.hasKey((Object)"onCapacityOverload"));
    }

    @Test
    public void sourceErrorIntercepted() throws Exception {
        this.startFlow("sourceErrorIntercepted");
        CountDownLatch afterCalledLatch = new CountDownLatch(1);
        SourceCallbackInterceptor.afterCallback = (event, thrown) -> thrown.ifPresent(t -> afterCalledLatch.countDown());
        Assert.assertThat((Object)afterCalledLatch.await(5000L, TimeUnit.MILLISECONDS), (Matcher)Matchers.is((Object)true));
        List<ProcessorInterceptorFactoryTestCase.InterceptionParameters> interceptionParameters = SourceCallbackInterceptor.interceptionParameters;
        Assert.assertThat(interceptionParameters, (Matcher)Matchers.hasSize((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1))));
        ProcessorInterceptorFactoryTestCase.InterceptionParameters heisenbergSourceInterceptionParameter = interceptionParameters.get(interceptionParameters.size() - 1);
        Assert.assertThat(heisenbergSourceInterceptionParameter.getParameters().entrySet(), (Matcher)Matchers.hasSize((int)8));
    }

    protected void startFlow(String flowName) throws Exception {
        this.flow = (Flow)this.getFlowConstruct(flowName);
        this.flow.start();
    }

    public static class SourceCallbackInterceptor
    implements SourceInterceptor {
        static BiConsumer<InterceptionEvent, Optional<Throwable>> afterCallback = (event, thrown) -> {};
        static final List<ProcessorInterceptorFactoryTestCase.InterceptionParameters> interceptionParameters = new LinkedList<ProcessorInterceptorFactoryTestCase.InterceptionParameters>();

        public void beforeCallback(ComponentLocation location, Map<String, ProcessorParameterValue> parameters, InterceptionEvent event) {
            interceptionParameters.add(new ProcessorInterceptorFactoryTestCase.InterceptionParameters(location, parameters, event));
        }

        public void afterCallback(ComponentLocation location, InterceptionEvent event, Optional<Throwable> thrown) {
            afterCallback.accept(event, thrown);
        }
    }

    public static class SourceCallbackInterceptorFactory
    implements SourceInterceptorFactory {
        public SourceInterceptor get() {
            return new SourceCallbackInterceptor();
        }
    }
}

