/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.locator;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.source.SchedulerMessageSource;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.source.MessageSource;
import org.mule.test.AbstractIntegrationTestCase;

@Feature(value="Configuration component locator")
@Story(value="Search configuration")
public class ConfigurationComponentLocatorTestCase
extends AbstractIntegrationTestCase {
    protected String getConfigFile() {
        return "org/mule/test/integration/locator/component-locator-config.xml";
    }

    @Description(value="Search for a global component that do not exists return an empty optional")
    @Test
    public void globalObjectNotFound() {
        Assert.assertThat((Object)muleContext.getConfigurationComponentLocator().find(Location.builder().globalName("nonExistent").build()).isPresent(), (Matcher)Is.is((Object)false));
    }

    @Description(value="Search for a global component found returns an Optional with the proper value")
    @Test
    public void globalObjectFound() {
        Optional myFlow = muleContext.getConfigurationComponentLocator().find(Location.builder().globalName("myFlow").build());
        Assert.assertThat((Object)myFlow.isPresent(), (Matcher)Is.is((Object)true));
        Assert.assertThat(myFlow.get(), (Matcher)IsInstanceOf.instanceOf(Flow.class));
    }

    @Description(value="Search for a component with an non existent global component part returns an empty optional")
    @Test
    public void badContainerType() {
        Location location = Location.builder().globalName("pepe").addProcessorsPart().addIndexPart(0).build();
        Assert.assertThat((Object)muleContext.getConfigurationComponentLocator().find(location).isPresent(), (Matcher)Is.is((Object)false));
    }

    @Description(value="Search for a message source component by the flow component name")
    @Test
    public void sourceByPath() {
        Location sourceLocation = Location.builder().globalName("myFlow").addSourcePart().build();
        Optional source = muleContext.getConfigurationComponentLocator().find(sourceLocation);
        Assert.assertThat((Object)source.isPresent(), (Matcher)Is.is((Object)true));
        Assert.assertThat(source.get(), (Matcher)IsInstanceOf.instanceOf(MessageSource.class));
    }

    @Description(value="Search message processors components within a flow")
    @Test
    public void messageProcessorByPath() {
        Location.Builder myFlowProcessorsLocationBuilder = Location.builder().globalName("myFlow").addProcessorsPart();
        Optional processor = muleContext.getConfigurationComponentLocator().find(myFlowProcessorsLocationBuilder.addIndexPart(0).build());
        Assert.assertThat((Object)processor.isPresent(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)((Component)processor.get()).getClass().getName(), (Matcher)Matchers.equalTo((Object)"org.mule.runtime.core.internal.processor.LoggerMessageProcessor"));
        processor = muleContext.getConfigurationComponentLocator().find(myFlowProcessorsLocationBuilder.addIndexPart(1).build());
        Assert.assertThat((Object)processor.isPresent(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)((Component)processor.get()).getClass().getName(), (Matcher)Matchers.equalTo((Object)"org.mule.runtime.core.internal.processor.simple.SetPayloadMessageProcessor"));
        processor = muleContext.getConfigurationComponentLocator().find(myFlowProcessorsLocationBuilder.addIndexPart(2).build());
        Assert.assertThat((Object)processor.isPresent(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)((Component)processor.get()).getClass().getName(), (Matcher)Matchers.equalTo((Object)"org.mule.runtime.core.internal.processor.AsyncDelegateMessageProcessor"));
        processor = muleContext.getConfigurationComponentLocator().find(myFlowProcessorsLocationBuilder.addIndexPart(2).addProcessorsPart().addIndexPart(0).build());
        Assert.assertThat((Object)processor.isPresent(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)((Component)processor.get()).getClass().getName(), (Matcher)Matchers.equalTo((Object)"org.mule.runtime.core.internal.processor.simple.SetPayloadMessageProcessor"));
        processor = muleContext.getConfigurationComponentLocator().find(myFlowProcessorsLocationBuilder.addIndexPart(2).addProcessorsPart().addIndexPart(1).build());
        Assert.assertThat((Object)processor.isPresent(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)((Component)processor.get()).getClass().getName(), (Matcher)Matchers.equalTo((Object)"org.mule.runtime.core.internal.processor.LoggerMessageProcessor"));
    }

    @Description(value="Search all scheduler message sources within the configuration")
    @Test
    public void findAllSchedulers() {
        List components = muleContext.getConfigurationComponentLocator().find(SchedulerMessageSource.SCHEDULER_MESSAGE_SOURCE_IDENTIFIER);
        Assert.assertThat((Object)components, (Matcher)Matchers.hasSize((int)3));
        Assert.assertThat(components.stream().map(component -> component.getLocation().getRootContainerName()).collect(Collectors.toList()), (Matcher)Matchers.hasItems((Object[])new String[]{"myFlow", "anotherFlow"}));
    }

    @Description(value="Search by ComponentIdentifier returns empty collection when no elements could be found")
    @Test
    public void notFoundComponentByComponentIdentifierReturnsEmptyCollection() {
        List components = muleContext.getConfigurationComponentLocator().find(ComponentIdentifier.buildFromStringRepresentation((String)"mule:nonExistent"));
        Assert.assertThat((Object)components, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)components, (Matcher)Matchers.hasSize((int)0));
    }

    @Description(value="Search for all the components in the configuration")
    @Test
    public void findAllComponents() {
        List componentLocs = muleContext.getConfigurationComponentLocator().findAllLocations();
        List allComponentPaths = componentLocs.stream().map(ComponentLocation::getLocation).collect(Collectors.toList());
        Assert.assertThat(allComponentPaths, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"myFlow", "myFlow/source", "myFlow/processors/0", "myFlow/processors/1", "myFlow/processors/2", "myFlow/processors/2/processors/0", "myFlow/processors/2/processors/1", "anotherFlow", "anotherFlow/source", "anotherFlow/processors/0", "flowWithSubflow", "flowWithSubflow/processors/0", "mySubFlow", "mySubFlow/processors/0", "flowFailing", "flowFailing/processors/0", "_muleConfiguration", "globalErrorHandler", "globalErrorHandler/0", "globalErrorHandler/0/processors/0", "fileListWithMatcherReference", "fileListWithMatcherReference/source", "fileListWithMatcherReference/processors/0", "Matcher", "listenerConfigRedeliveryPolicy", "listenerConfigRedeliveryPolicy/0", "redeliveryPolicyFlow", "redeliveryPolicyFlow/source", "redeliveryPolicyFlow/source/0", "redeliveryPolicyFlow/processors/0"}));
    }
}

