/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.locator;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.hamcrest.core.IsNot;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.config.api.LazyComponentInitializer;
import org.mule.runtime.config.api.SpringXmlConfigurationBuilderFactory;
import org.mule.runtime.core.api.config.ConfigurationBuilder;
import org.mule.test.AbstractIntegrationTestCase;

@Feature(value="Configuration component locator")
@Story(value="Search configuration")
public class ErrorHandlerLazyInitTestCase
extends AbstractIntegrationTestCase {
    @Inject
    private Registry registry;
    @Inject
    @Named(value="_muleLazyComponentInitializer")
    private LazyComponentInitializer lazyComponentInitializer;

    protected String[] getConfigFiles() {
        return new String[]{"org/mule/test/integration/locator/component-locator-error-mapping.xml"};
    }

    public boolean enableLazyInit() {
        return true;
    }

    protected ConfigurationBuilder getBuilder() throws Exception {
        ConfigurationBuilder configurationBuilder = SpringXmlConfigurationBuilderFactory.createConfigurationBuilder((String[])this.getConfigFiles(), (boolean)true);
        this.configureSpringXmlConfigurationBuilder(configurationBuilder);
        return configurationBuilder;
    }

    @Test
    public void customErrorTypesShouldDiscovered() {
        this.lazyComponentInitializer.initializeComponent(Location.builder().globalName("mainFlow").build());
        ErrorTypeRepository errorTypeRepository = (ErrorTypeRepository)this.registry.lookupByType(ErrorTypeRepository.class).orElseThrow(() -> new AssertionError((Object)"Cannot access errorTypeRepository"));
        this.assertApplicationCustomErrorTypes(errorTypeRepository, "APP:ERROR_TYPE_1");
        this.assertApplicationCustomErrorTypes(errorTypeRepository, "APP:ERROR_TYPE_2");
    }

    public void assertApplicationCustomErrorTypes(ErrorTypeRepository errorTypeRepository, String errorType) {
        Optional appMyErrorType = errorTypeRepository.getErrorType(ComponentIdentifier.buildFromStringRepresentation((String)errorType));
        Assert.assertThat((Object)appMyErrorType, (Matcher)IsNot.not(Optional.empty()));
        Assert.assertThat((Object)((ErrorType)appMyErrorType.get()).getParentErrorType(), (Matcher)IsEqual.equalTo((Object)errorTypeRepository.getAnyErrorType()));
    }
}

