/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.locator;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsCollectionContaining;
import org.junit.Assert;
import org.junit.Test;
import org.mule.extension.spring.api.SpringConfig;
import org.mule.functional.api.component.TestConnectorQueueHandler;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.config.api.LazyComponentInitializer;
import org.mule.runtime.config.api.SpringXmlConfigurationBuilderFactory;
import org.mule.runtime.core.api.config.ConfigurationBuilder;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.security.SecurityManager;
import org.mule.test.AbstractIntegrationTestCase;

@Feature(value="Configuration component locator")
@Story(value="Search configuration")
public class LazyInitConfigurationComponentLocatorTestCase
extends AbstractIntegrationTestCase {
    private static final int TOTAL_NUMBER_OF_LOCATIONS = 107;
    @Inject
    private Registry registry;
    @Inject
    @Named(value="_muleLazyComponentInitializer")
    private LazyComponentInitializer lazyComponentInitializer;

    protected String[] getConfigFiles() {
        return new String[]{"org/mule/test/integration/locator/component-locator-config.xml", "org/mule/test/integration/locator/component-locator-levels-config.xml", "org/mule/test/integration/locator/component-locator-spring-config.xml", "org/mule/test/integration/locator/component-locator-reference-component-models.xml", "org/mule/test/integration/locator/module-with-config-oauth.xml"};
    }

    public boolean enableLazyInit() {
        return true;
    }

    protected ConfigurationBuilder getBuilder() throws Exception {
        ConfigurationBuilder configurationBuilder = SpringXmlConfigurationBuilderFactory.createConfigurationBuilder((String[])this.getConfigFiles(), (boolean)true);
        this.configureSpringXmlConfigurationBuilder(configurationBuilder);
        return configurationBuilder;
    }

    @Description(value="Lazy init should not create components until an operation is done")
    @Test
    public void lazyInitCalculatesLocations() {
        List allLocations = this.locator.findAllLocations().stream().map(ComponentLocation::getLocation).collect(Collectors.toList());
        Assert.assertThat((String)allLocations.toString(), allLocations, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"myFlow", "myFlow/source", "myFlow/source/0", "myFlow/source/0/0", "myFlow/processors/0", "myFlow/processors/1", "myFlow/processors/2", "myFlow/processors/2/processors/0", "myFlow/processors/2/processors/1", "anotherFlow", "anotherFlow/source", "anotherFlow/source/0", "anotherFlow/source/0/0", "anotherFlow/processors/0", "flowWithSubflow", "flowWithSubflow/processors/0", "mySubFlow", "mySubFlow/processors/0", "_muleConfiguration", "globalErrorHandler", "globalErrorHandler/0", "globalErrorHandler/0/processors/0", "flowFailing", "flowFailing/processors/0", "flowLvl0", "flowLvl0/processors/0", "flowLvl1", "flowLvl1/processors/0", "flowLvl2", "flowLvl2/processors/0", "flowLvl2/processors/0/0", "flowLvl2/processors/1", "dbConfig", "dbConfig/0", "requestConfig", "requestConfig/0", "tlsContextRef", "tlsContextRef/0", "springConfig", "globalObjectStore", "globalObjectStoreAggregatorFlow", "globalObjectStoreAggregatorFlow/processors/0", "globalObjectStoreAggregatorFlow/processors/0/route/0", "globalObjectStoreAggregatorFlow/processors/0/route/0/processors/0", "aggregatorWithMaxSizeFlow", "aggregatorWithMaxSizeFlow/processors/0", "aggregatorWithMaxSizeListenerFlow", "aggregatorWithMaxSizeListenerFlow/source", "aggregatorWithMaxSizeListenerFlow/processors/0", "aggregatorOnListenerFlow", "aggregatorOnListenerFlow/processors/0", "aggregatorWithMaxSizeFlow/processors/1", "justAnotherFlowThatShouldNotBeInitialized", "justAnotherFlowThatShouldNotBeInitialized/processors/0", "tokenManagerConfig-sample-config", "github-httpreq-config-sample-config", "github-httpreq-config-sample-config/0", "github-httpreq-config-sample-config/0/0", "github-httpreq-config-sample-config/0/0/0", "get-channels/processors/0", "get-channels/processors/0/0", "get-channels/processors/0/1", "get-channels/processors/1", "GetChannels", "GetChannels/source", "GetChannels/source/0", "GetChannels/source/0/0", "GetChannels/processors/0", "GetChannels/processors/0/0", "GetChannels/processors/0/0/0", "GetChannels/processors/0/0/1", "GetChannels/processors/0/0/2", "GetChannels/processors/0/0/3", "GetChannels/processors/0/0/4", "GetChannels/processors/0/0/5", "GetChannels/processors/0/0/6", "GetChannels/processors/0/1", "null", "null/0", "listenerConfig", "listenerConfig/0", "SecureUMO", "SecureUMO/source", "SecureUMO/processors/0", "SecureUMO/processors/1", "SecureUMO/processors/1/0", "SecureUMO2", "SecureUMO2/source", "SecureUMO2/processors/0", "SecureUMO2/processors/0/0", "SecureUMO2/processors/0/0/0", "SecureUMO2/processors/1", "SecureUMO2/processors/1/0", "securityManager2", "securityManager2/0", "Matcher", "fileListWithMatcherReference", "fileListWithMatcherReference/source", "fileListWithMatcherReference/source/0", "fileListWithMatcherReference/source/0/0", "fileListWithMatcherReference/processors/0", "listenerConfigRedeliveryPolicy", "listenerConfigRedeliveryPolicy/0", "redeliveryPolicyFlow", "redeliveryPolicyFlow/source", "redeliveryPolicyFlow/source/0", "redeliveryPolicyFlow/processors/0"}));
        Assert.assertThat((Object)this.locator.find(Location.builder().globalName("myFlow").build()), (Matcher)Matchers.is(Optional.empty()));
        Assert.assertThat((Object)this.locator.find(Location.builder().globalName("anotherFlow").build()), (Matcher)Matchers.is(Optional.empty()));
    }

    @Description(value="Lazy init should create components when operation is done")
    @Test
    public void lazyMuleContextInitializesLocation() {
        this.lazyComponentInitializer.initializeComponent(Location.builder().globalName("myFlow").build());
        Assert.assertThat((Object)this.locator.find(Location.builder().globalName("myFlow").build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
        Assert.assertThat((Object)this.locator.find(Location.builder().globalName("anotherFlow").build()), (Matcher)Matchers.is(Optional.empty()));
        Assert.assertThat(this.locator.findAllLocations().stream().map(ComponentLocation::getLocation).collect(Collectors.toList()), (Matcher)IsCollectionContaining.hasItem((Object)"myFlow/source"));
    }

    @Description(value="Lazy init should refresh the ConfigurationComponentLocator when initialize is done")
    @Test
    public void lazyMuleContextRefreshesConfigurationComponentLoader() {
        this.lazyComponentInitializer.initializeComponent(Location.builder().globalName("myFlow").build());
        Assert.assertThat((Object)this.locator.findAllLocations(), (Matcher)Matchers.hasSize((int)107));
        this.lazyComponentInitializer.initializeComponent(Location.builder().globalName("anotherFlow").build());
        Assert.assertThat((Object)this.locator.findAllLocations(), (Matcher)Matchers.hasSize((int)107));
        Assert.assertThat((Object)this.locator.find(Location.builder().globalName("myFlow").build()), (Matcher)Matchers.is(Optional.empty()));
        Assert.assertThat((Object)this.locator.find(Location.builder().globalName("anotherFlow").build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
    }

    @Description(value="Lazy init should keep siblings enabled when requested")
    @Test
    public void lazyMuleContextSiblingNodesEnabled() {
        this.lazyComponentInitializer.initializeComponents(componentLocation -> {
            String location = componentLocation.getLocation();
            return location.equals("myFlow/source/0") || location.equals("myFlow/processors/2/processors/0");
        });
        Assert.assertThat((Object)muleContext.getConfigurationComponentLocator().findAllLocations(), (Matcher)Matchers.hasSize((int)107));
        this.lazyComponentInitializer.initializeComponents(componentLocation -> {
            String location = componentLocation.getLocation();
            return location.equals("myFlow/source/0") || location.equals("myFlow/processors/2/processors/0");
        });
        Assert.assertThat((Object)this.locator.find(Location.builderFromStringRepresentation((String)"myFlow").build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
        Assert.assertThat((Object)this.locator.find(Location.builderFromStringRepresentation((String)"myFlow/source").build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
        Assert.assertThat((Object)this.locator.find(Location.builderFromStringRepresentation((String)"myFlow/processors/2").build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
        Assert.assertThat((Object)this.locator.find(Location.builderFromStringRepresentation((String)"myFlow/processors/2/processors/0").build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
        Assert.assertThat((Object)this.locator.find(Location.builderFromStringRepresentation((String)"springConfig").build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
    }

    @Test
    public void lazyMuleContextWithDeeperLevelConfig() {
        this.lazyComponentInitializer.initializeComponent(Location.builder().globalName("flowLvl0").build());
        Assert.assertThat((Object)this.locator.find(Location.builder().globalName("flowLvl0").build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
        Assert.assertThat((Object)this.locator.find(Location.builder().globalName("flowLvl0").addProcessorsPart().addIndexPart(0).build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
        Assert.assertThat((Object)this.locator.find(Location.builder().globalName("flowLvl1").build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
        Assert.assertThat((Object)this.locator.find(Location.builder().globalName("flowLvl1").addProcessorsPart().addIndexPart(0).build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
        Assert.assertThat((Object)this.locator.find(Location.builder().globalName("flowLvl2").build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
        Assert.assertThat((Object)this.locator.find(Location.builder().globalName("flowLvl2").addProcessorsPart().addIndexPart(0).build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
        Assert.assertThat((Object)this.locator.find(Location.builder().globalName("flowLvl2").addProcessorsPart().addIndexPart(1).build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
        Assert.assertThat((Object)this.locator.find(Location.builder().globalName("dbConfig").build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
        Assert.assertThat((Object)this.locator.find(Location.builder().globalName("requestConfig").build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
        Assert.assertThat((Object)this.locator.find(Location.builder().globalName("tlsContextRef").build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
    }

    @Test
    public void fileListShouldInitializeMatcherReference() {
        this.lazyComponentInitializer.initializeComponent(Location.builder().globalName("fileListWithMatcherReference").addProcessorsPart().addIndexPart(0).build());
        Assert.assertThat((Object)this.locator.find(Location.builder().globalName("fileListWithMatcherReference").build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
        Assert.assertThat((Object)this.locator.find(Location.builder().globalName("fileListWithMatcherReference").addProcessorsPart().addIndexPart(0).build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
    }

    @Test
    public void lazyMuleContextShouldInitializeOnlyTheProcessorRequested() {
        this.lazyComponentInitializer.initializeComponent(Location.builder().globalName("flowLvl2").addProcessorsPart().addIndexPart(1).build());
        Assert.assertThat((Object)this.locator.find(Location.builder().globalName("flowLvl2").build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
        Assert.assertThat((Object)this.locator.find(Location.builder().globalName("flowLvl2").addProcessorsPart().addIndexPart(0).build()), (Matcher)Matchers.is(Optional.empty()));
        Assert.assertThat((Object)this.locator.find(Location.builder().globalName("flowLvl2").addProcessorsPart().addIndexPart(1).build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
    }

    @Description(value="Lazy init should create spring components without dependencies")
    @Test
    public void lazyMuleContextInitializesSpringConfig() throws IllegalAccessException {
        this.lazyComponentInitializer.initializeComponents(componentLocation -> componentLocation.getLocation().equals("myFlow"));
        Assert.assertThat((Object)this.locator.find(Location.builderFromStringRepresentation((String)"myFlow").build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
        Assert.assertThat((Object)this.locator.find(Location.builderFromStringRepresentation((String)"myFlow/source").build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
        Assert.assertThat((Object)this.locator.find(Location.builderFromStringRepresentation((String)"myFlow/processors/0").build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
        Assert.assertThat((Object)this.locator.find(Location.builderFromStringRepresentation((String)"myFlow/processors/1").build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
        Assert.assertThat((Object)this.locator.find(Location.builderFromStringRepresentation((String)"myFlow/processors/2").build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
        Assert.assertThat((Object)this.locator.find(Location.builderFromStringRepresentation((String)"myFlow/processors/2/processors/0").build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
        Assert.assertThat((Object)this.locator.find(Location.builderFromStringRepresentation((String)"myFlow/processors/2/processors/1").build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
        Assert.assertThat((Object)this.locator.find(Location.builderFromStringRepresentation((String)"springConfig").build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
        Assert.assertThat((Object)this.registry.lookupByName("springConfig").isPresent(), (Matcher)Matchers.is((Object)true));
        SpringConfig springConfig = (SpringConfig)this.registry.lookupByName("springConfig").get();
        Object applicationContext = FieldUtils.readField((Object)springConfig, (String)"applicationContext", (boolean)true);
        Assert.assertThat((String)"springConfig was not configured", (Object)applicationContext, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)springConfig.getObject("child1").isPresent(), (Matcher)Matchers.is((Object)true));
    }

    @Description(value="Lazy init should create spring components without dependencies")
    @Test
    public void lazyMuleContextShouldNotFailWhenTryingToInitializeGlobalProperty() throws IllegalAccessException {
        this.lazyComponentInitializer.initializeComponents(componentLocation -> componentLocation.getLocation().equals("some.property"));
        Assert.assertThat((Object)this.locator.find(Location.builderFromStringRepresentation((String)"some.property").build()), (Matcher)Matchers.is(Optional.empty()));
    }

    @Description(value="Lazy init should create spring security manager without dependencies")
    @Test
    public void lazyMuleContextInitializesSpringSecurityManager() throws IllegalAccessException {
        this.lazyComponentInitializer.initializeComponents(componentLocation -> componentLocation.getLocation().equals("SecureUMO"));
        Assert.assertThat((Object)this.locator.find(Location.builderFromStringRepresentation((String)"listenerConfig").build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
        Assert.assertThat((Object)this.locator.find(Location.builderFromStringRepresentation((String)"listenerConfig/0").build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
        Assert.assertThat((Object)this.locator.find(Location.builderFromStringRepresentation((String)"SecureUMO/source").build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
        Assert.assertThat((Object)this.locator.find(Location.builderFromStringRepresentation((String)"SecureUMO/processors/0").build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
        Assert.assertThat((Object)this.locator.find(Location.builderFromStringRepresentation((String)"SecureUMO/processors/1").build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
        Assert.assertThat((Object)this.registry.lookupByName("_muleSecurityManager").isPresent(), (Matcher)Matchers.is((Object)true));
        SecurityManager securityManager = (SecurityManager)this.registry.lookupByName("_muleSecurityManager").get();
        Assert.assertThat((String)"spring security provider was not registered", (Object)securityManager.getProvider("memory-dao"), (Matcher)Matchers.notNullValue());
    }

    @Description(value="Lazy init should create spring security manager without dependencies")
    @Test
    public void lazyMuleContextInitializesNamedSpringSecurityManager() throws IllegalAccessException {
        this.lazyComponentInitializer.initializeComponents(componentLocation -> componentLocation.getLocation().equals("SecureUMO2"));
        Assert.assertThat((Object)this.locator.find(Location.builderFromStringRepresentation((String)"listenerConfig").build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
        Assert.assertThat((Object)this.locator.find(Location.builderFromStringRepresentation((String)"listenerConfig/0").build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
        Assert.assertThat((Object)this.locator.find(Location.builderFromStringRepresentation((String)"SecureUMO2/source").build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
        Assert.assertThat((Object)this.locator.find(Location.builderFromStringRepresentation((String)"SecureUMO2/processors/0").build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
        Assert.assertThat((Object)this.locator.find(Location.builderFromStringRepresentation((String)"SecureUMO2/processors/1").build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
        Assert.assertThat((Object)this.registry.lookupByName("_muleSecurityManager").isPresent(), (Matcher)Matchers.is((Object)true));
        SecurityManager securityManager = (SecurityManager)this.registry.lookupByName("securityManager2").get();
        Assert.assertThat((String)"spring security provider was not registered", (Object)securityManager.getProvider("memory-dao2"), (Matcher)Matchers.notNullValue());
    }

    @Description(value="Spring component should be created each time as the rest")
    @Test
    public void lazyMuleContextSpringConfigRebuilt() throws IllegalAccessException {
        this.lazyComponentInitializer.initializeComponents(componentLocation -> componentLocation.getLocation().equals("myFlow"));
        Assert.assertThat((Object)this.locator.find(Location.builderFromStringRepresentation((String)"springConfig").build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
        Object firstObj = this.locator.find(Location.builderFromStringRepresentation((String)"springConfig").build()).get();
        this.lazyComponentInitializer.initializeComponents(componentLocation -> componentLocation.getLocation().equals("anotherFlow"));
        Assert.assertThat((Object)this.locator.find(Location.builderFromStringRepresentation((String)"springConfig").build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
        Object secondObj = this.locator.find(Location.builderFromStringRepresentation((String)"springConfig").build()).get();
        Object secondAppContext = FieldUtils.readField(secondObj, (String)"applicationContext", (boolean)true);
        Assert.assertThat((String)"springConfig was not configured", (Object)secondAppContext, (Matcher)Matchers.notNullValue());
        Assert.assertThat(firstObj, (Matcher)Matchers.not((Matcher)Matchers.sameInstance(secondObj)));
    }

    @Test
    public void lazyMuleContextSmartConnectorsWithConfig() throws IllegalAccessException {
        this.lazyComponentInitializer.initializeComponents(componentLocation -> componentLocation.getLocation().equals("GetChannels"));
        Assert.assertThat((Object)this.locator.find(Location.builderFromStringRepresentation((String)"GetChannels").build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
        Assert.assertThat((Object)this.locator.find(Location.builderFromStringRepresentation((String)"GetChannels/processors/0").build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
    }

    @Description(value="Lazy init should create components that are references by other components, when the reference is not a top level element")
    @Test
    public void componentModelReferencesToNonTopLevelElement() {
        this.lazyComponentInitializer.initializeComponent(Location.builder().globalName("aggregatorWithMaxSizeListenerFlow").build());
        Assert.assertThat((Object)this.locator.find(Location.builder().globalName("aggregatorWithMaxSizeFlow").build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
        Assert.assertThat((Object)this.locator.find(Location.builder().globalName("aggregatorWithMaxSizeFlow").addProcessorsPart().addIndexPart(0).build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
        Assert.assertThat((Object)this.locator.find(Location.builder().globalName("aggregatorWithMaxSizeFlow").addProcessorsPart().addIndexPart(1).build()), (Matcher)Matchers.is(Optional.empty()));
        Assert.assertThat((Object)this.locator.find(Location.builder().globalName("justAnotherFlowThatShouldNotBeInitialized").build()), (Matcher)Matchers.is(Optional.empty()));
    }

    @Test
    public void globalErrorHandlerApplied() throws Exception {
        this.lazyComponentInitializer.initializeComponent(Location.builder().globalName("flowFailing").build());
        this.flowRunner("flowFailing").runExpectingException();
        TestConnectorQueueHandler queueHandler = new TestConnectorQueueHandler(this.registry);
        Assert.assertThat((Object)queueHandler.read("globalErrorHandlerQueue", 5000L), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void globalMuleConfigurationDefaultResponseTimeout() throws Exception {
        MuleConfiguration configuration = (MuleConfiguration)this.registry.lookupByType(MuleConfiguration.class).orElseThrow(() -> new AssertionError((Object)"Missing MuleConfiguration from registry"));
        Assert.assertThat((Object)configuration.getDefaultResponseTimeout(), (Matcher)Matchers.is((Object)2001));
    }

    @Description(value="Search for sub-flows components")
    @Test
    public void findSubFlowComponents() {
        this.lazyComponentInitializer.initializeComponent(Location.builder().globalName("mySubFlow").addProcessorsPart().addIndexPart(0).build());
        Optional componentOptional = muleContext.getConfigurationComponentLocator().find(Location.builder().globalName("mySubFlow").addProcessorsPart().addIndexPart(0).build());
        Assert.assertThat((Object)componentOptional.isPresent(), (Matcher)Matchers.is((Object)true));
    }
}

