/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.routing;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import org.apache.commons.lang3.SerializationUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.functional.api.notification.FunctionalTestNotification;
import org.mule.functional.listener.FlowExecutionListener;
import org.mule.runtime.api.notification.AbstractServerNotification;
import org.mule.runtime.api.notification.NotificationListenerRegistry;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.test.integration.routing.SimpleSerializableObject;

public class MessageChunkingTestCase
extends AbstractIntegrationTestCase {
    @Inject
    private NotificationListenerRegistry notificationRegistry;

    protected String getConfigFile() {
        return "org/mule/test/integration/routing/message-chunking-flow.xml";
    }

    @Test
    public void testMessageChunkingWithEvenSplit() throws Exception {
        this.doMessageChunking("0123456789", 5);
    }

    @Test
    public void testMessageChunkingWithOddSplit() throws Exception {
        this.doMessageChunking("01234567890", 6);
    }

    @Test
    public void testMessageChunkingWith100Splits() throws Exception {
        this.doMessageChunking("01234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789", 100);
    }

    @Test
    public void testMessageChunkingOneChunk() throws Exception {
        this.doMessageChunking("x", 1);
    }

    @Test
    public void testMessageChunkingObject() throws Exception {
        AtomicInteger messagePartsCount = new AtomicInteger(0);
        SimpleSerializableObject simpleSerializableObject = new SimpleSerializableObject("Test String", true, 99);
        int parts = (int)Math.ceil((double)SerializationUtils.serialize((Serializable)simpleSerializableObject).length / 2.0);
        this.notificationRegistry.registerListener(notification -> {
            Assert.assertEquals((Object)"ChunkingObjectReceiver", (Object)((AbstractServerNotification)notification).getResourceIdentifier());
            Object reply = ((FunctionalTestNotification)notification).getMessage().getPayload().getValue();
            Assert.assertTrue((boolean)(reply instanceof SimpleSerializableObject));
            SimpleSerializableObject replySimpleSerializableObject = (SimpleSerializableObject)reply;
            Assert.assertEquals((Object)simpleSerializableObject.b, (Object)replySimpleSerializableObject.b);
            Assert.assertEquals((long)simpleSerializableObject.i, (long)replySimpleSerializableObject.i);
            Assert.assertEquals((Object)simpleSerializableObject.s, (Object)replySimpleSerializableObject.s);
        }, m -> "ChunkingObjectReceiver".equals(((AbstractServerNotification)m).getResourceIdentifier()));
        FlowExecutionListener flowExecutionListener = new FlowExecutionListener("ChunkingObjectReceiver", this.notificationListenerRegistry);
        flowExecutionListener.addListener(source -> messagePartsCount.getAndIncrement());
        ((FlowRunner)this.flowRunner("ObjectReceiver").withPayload((Object)simpleSerializableObject)).run();
        Assert.assertEquals((long)parts, (long)messagePartsCount.get());
    }

    protected void doMessageChunking(String data, int partsCount) throws Exception {
        AtomicInteger messagePartsCount = new AtomicInteger(0);
        this.notificationListenerRegistry.registerListener(notification -> {
            Assert.assertEquals((Object)"ChunkingReceiver", (Object)((AbstractServerNotification)notification).getResourceIdentifier());
            Object reply = ((FunctionalTestNotification)notification).getReplyMessage();
            Assert.assertEquals((Object)(data + " Received"), (Object)reply);
        }, m -> "ChunkingReceiver".equals(((AbstractServerNotification)m).getResourceIdentifier()));
        FlowExecutionListener flowExecutionListener = new FlowExecutionListener("ChunkingReceiver", this.notificationListenerRegistry);
        flowExecutionListener.addListener(notificationInfo -> messagePartsCount.getAndIncrement());
        ((FlowRunner)this.flowRunner("Receiver").withPayload((Object)data)).run();
        Assert.assertEquals((long)partsCount, (long)messagePartsCount.get());
    }
}

