/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.transaction;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.functional.api.component.FunctionalTestProcessor;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.notification.NotificationListener;
import org.mule.runtime.api.notification.TransactionNotification;
import org.mule.runtime.api.notification.TransactionNotificationListener;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.tck.probe.JUnitProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.test.AbstractIntegrationTestCase;

public class TransactionalElementLifecycleTestCase
extends AbstractIntegrationTestCase {
    private static final int POLL_DELAY_MILLIS = 100;
    private List<TransactionNotification> notifications;

    protected String getConfigFile() {
        return "org/mule/test/integration/transaction/transactional-lifecycle-config.xml";
    }

    protected void doSetUp() throws Exception {
        this.notifications = new ArrayList<TransactionNotification>();
    }

    @Test
    public void testInitializeIsCalledInInnerExceptionStrategy() throws Exception {
        TransactionNotificationListener<TransactionNotification> listener = new TransactionNotificationListener<TransactionNotification>(){

            public boolean isBlocking() {
                return false;
            }

            public void onNotification(TransactionNotification notification) {
                TransactionalElementLifecycleTestCase.this.notifications.add(notification);
            }
        };
        TransactionalElementLifecycleTestCase.muleContext.getNotificationManager().addListener((NotificationListener)listener);
        Latch endDlqFlowLatch = new Latch();
        FunctionalTestProcessor.getFromFlow((ConfigurationComponentLocator)this.locator, (String)"dlq-out").setEventCallback((context, component, muleContext) -> endDlqFlowLatch.release());
        ((FlowRunner)this.flowRunner("in-flow").withPayload((Object)"message")).run();
        if (!endDlqFlowLatch.await(5000L, TimeUnit.MILLISECONDS)) {
            Assert.fail((String)"message wasn't received by dlq flow");
        }
        this.assertNotificationsArrived();
        this.assertApplicationName();
    }

    private void assertApplicationName() {
        for (TransactionNotification notification : this.notifications) {
            Assert.assertThat((Object)notification.getApplicationName(), (Matcher)CoreMatchers.is((Object)muleContext.getConfiguration().getId()));
        }
    }

    private void assertNotificationsArrived() {
        PollingProber pollingProber = new PollingProber(5000L, 100L);
        pollingProber.check((Probe)new JUnitProbe(){

            protected boolean test() throws Exception {
                Assert.assertThat((Object)TransactionalElementLifecycleTestCase.this.notifications.size(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(2)));
                return true;
            }

            public String describeFailure() {
                return "Notifications did not arrive";
            }
        });
    }
}

