/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.processors;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.test.AbstractIntegrationTestCase;

public class ParseTemplateTestCase
extends AbstractIntegrationTestCase {
    private static final String PARSED_NO_EXPRESSION = "This template does not have any expressions to parse";
    private static final String PARSED_MEL_EXPRESSION = "This template has a MEL expression to parse from mel-expression flow";
    private static final String PARSED_DW_EXPRESSION = "This template has a DW expression to parse from dw-expression flow. Remember, the name of the flow is dw-expression";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    public String getConfigFile() {
        return "org/mule/processors/parse-template-config.xml";
    }

    @Test
    public void testNoExpressionInline() throws Exception {
        CoreEvent event = this.flowRunner("no-expression-inline").run();
        String msg = (String)event.getMessage().getPayload().getValue();
        Assert.assertEquals((Object)PARSED_NO_EXPRESSION, (Object)msg);
    }

    @Test
    public void testMELExpressionInline() throws Exception {
        CoreEvent event = ((FlowRunner)this.flowRunner("mel-expression-inline").withVariable("flowName", (Object)"mel-expression")).run();
        String msg = (String)event.getMessage().getPayload().getValue();
        Assert.assertEquals((Object)PARSED_MEL_EXPRESSION, (Object)msg);
    }

    @Test
    public void testDWExpressionInline() throws Exception {
        CoreEvent event = ((FlowRunner)this.flowRunner("dw-expression-inline").withVariable("flowName", (Object)"dw-expression")).run();
        String msg = (String)event.getMessage().getPayload().getValue();
        Assert.assertEquals((Object)PARSED_DW_EXPRESSION, (Object)msg);
    }

    @Test
    public void testNoExpressionFromFile() throws Exception {
        CoreEvent event = this.flowRunner("no-expression").run();
        String msg = (String)event.getMessage().getPayload().getValue();
        Assert.assertEquals((Object)PARSED_NO_EXPRESSION, (Object)msg);
    }

    @Test
    public void testMELExpressionFromFile() throws Exception {
        CoreEvent event = ((FlowRunner)this.flowRunner("mel-expression").withVariable("flowName", (Object)"mel-expression")).run();
        String msg = (String)event.getMessage().getPayload().getValue();
        Assert.assertEquals((Object)PARSED_MEL_EXPRESSION, (Object)msg);
    }

    @Test
    public void testDWExpressionFromFile() throws Exception {
        CoreEvent event = ((FlowRunner)this.flowRunner("dw-expression").withVariable("flowName", (Object)"dw-expression")).run();
        String msg = (String)event.getMessage().getPayload().getValue();
        Assert.assertEquals((Object)PARSED_DW_EXPRESSION, (Object)msg);
    }

    @Test
    public void testNoExpressionFromLocation() throws Exception {
        CoreEvent event = this.flowRunner("no-expression-from-location").run();
        String msg = (String)event.getMessage().getPayload().getValue();
        Assert.assertEquals((Object)PARSED_NO_EXPRESSION, (Object)msg);
    }

    @Test
    public void testMELExpressionFromLocation() throws Exception {
        CoreEvent event = ((FlowRunner)this.flowRunner("mel-expression-from-location").withVariable("flowName", (Object)"mel-expression")).run();
        String msg = (String)event.getMessage().getPayload().getValue();
        Assert.assertEquals((Object)PARSED_MEL_EXPRESSION, (Object)msg);
    }

    @Test
    public void testDWExpressionFromLocation() throws Exception {
        CoreEvent event = ((FlowRunner)this.flowRunner("dw-expression-from-location").withVariable("flowName", (Object)"dw-expression")).run();
        String msg = (String)event.getMessage().getPayload().getValue();
        Assert.assertEquals((Object)PARSED_DW_EXPRESSION, (Object)msg);
    }

    @Test
    public void testWithTargetDefaultTargetValueDefinedInline() throws Exception {
        String startingPayload = "Starting payload";
        CoreEvent event = ((FlowRunner)((FlowRunner)this.flowRunner("with-target").withPayload((Object)startingPayload)).withVariable("flowName", (Object)"dw-expression")).run();
        String msg = (String)((Message)((TypedValue)event.getVariables().get("targetVar")).getValue()).getPayload().getValue();
        String previousdPayload = (String)event.getMessage().getPayload().getValue();
        Assert.assertEquals((Object)PARSED_DW_EXPRESSION, (Object)msg);
        Assert.assertEquals((Object)previousdPayload, (Object)startingPayload);
    }

    @Test
    public void testWithTargetValueButNoTargetShouldRaiseException() throws Exception {
        this.expectedException.expectCause(Matchers.isA(IllegalArgumentException.class));
        ((FlowRunner)this.flowRunner("with-target-value-no-target").withVariable("flowName", (Object)"dw-expression")).run();
    }

    @Test
    public void testWithCustomTargetValue() throws Exception {
        String startingPayload = "Starting payload";
        CoreEvent event = ((FlowRunner)((FlowRunner)this.flowRunner("with-custom-target-value").withPayload((Object)startingPayload)).withVariable("flowName", (Object)"dw-expression")).run();
        String savedPayload = (String)((TypedValue)((TypedValue)event.getVariables().get("targetVar")).getValue()).getValue();
        String previousPayload = (String)event.getMessage().getPayload().getValue();
        Assert.assertEquals((Object)PARSED_DW_EXPRESSION, (Object)savedPayload);
        Assert.assertEquals((Object)startingPayload, (Object)previousPayload);
    }

    @Test
    public void testWithWrongTargetValue() throws Exception {
        this.expectedException.expectCause(Matchers.isA(ExpressionRuntimeException.class));
        String startingPayload = "Starting payload";
        ((FlowRunner)((FlowRunner)this.flowRunner("with-wrong-target-value").withPayload((Object)startingPayload)).withVariable("flowName", (Object)"dw-expression")).run();
    }

    @Test
    public void testWithMessageBindingExpression() throws Exception {
        String startingPayload = "Starting payload";
        CoreEvent event = ((FlowRunner)((FlowRunner)this.flowRunner("with-message-binding-target-value").withPayload((Object)startingPayload)).withVariable("flowName", (Object)"dw-expression")).run();
        TypedValue savedTypedValue = (TypedValue)((TypedValue)event.getVariables().get("targetVar")).getValue();
        Assert.assertEquals((Object)savedTypedValue.getDataType().getType(), Message.class);
        String previousPayload = (String)event.getMessage().getPayload().getValue();
        Assert.assertEquals((Object)PARSED_DW_EXPRESSION, (Object)((Message)savedTypedValue.getValue()).getPayload().getValue());
        Assert.assertEquals((Object)startingPayload, (Object)previousPayload);
    }

    @Test
    public void testPayloadFromMessageBindingExpression() throws Exception {
        String startingPayload = "Starting payload";
        CoreEvent event = ((FlowRunner)((FlowRunner)this.flowRunner("with-payload-from-message-binding-target-value").withPayload((Object)startingPayload)).withVariable("flowName", (Object)"dw-expression")).run();
        TypedValue savedTypedValue = (TypedValue)((TypedValue)event.getVariables().get("targetVar")).getValue();
        String previousPayload = (String)event.getMessage().getPayload().getValue();
        Assert.assertEquals((Object)PARSED_DW_EXPRESSION, (Object)savedTypedValue.getValue());
        Assert.assertEquals((Object)startingPayload, (Object)previousPayload);
    }

    @Test
    public void testNestedExpressions() throws Exception {
        CoreEvent event = ((FlowRunner)((FlowRunner)((FlowRunner)this.flowRunner("nestedExpressionsFlow").withVariable("individuals", (Object)"alpinos")).withVariable("quantity", (Object)"3")).withVariable("origin", (Object)"guerra")).run();
        MatcherAssert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)Matchers.equalTo((Object)"Eran 3 alpinos que venian de la guerra"));
    }

    @Test
    public void testNestedExpressionsFromFile() throws Exception {
        CoreEvent event = ((FlowRunner)this.flowRunner("nestedExpressionsFlowFromFile").withVariable("chorusPhrase", (Object)"tiaitai rataplam")).run();
        MatcherAssert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)Matchers.equalTo((Object)"tiaitai rataplam, que venian de la guerra"));
    }
}

