/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.routing;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.concurrent.CountDownLatch;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mule.functional.api.component.TestConnectorQueueHandler;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.test.AbstractIntegrationTestCase;

@Feature(value="Routers")
@Story(value="Async")
public class AsyncTestCase
extends AbstractIntegrationTestCase {
    private static final int MAX_CONCURRENCY = 2;
    @Rule
    public SystemProperty maxConcurrency = new SystemProperty("maxConcurrency", "2");
    private TestConnectorQueueHandler queueHandler;
    private CountDownLatch terminationLatch;

    protected String getConfigFile() {
        return "org/mule/test/routing/async-test.xml";
    }

    @Before
    public void before() {
        this.queueHandler = new TestConnectorQueueHandler(this.registry);
    }

    @After
    public void after() throws InterruptedException {
        this.terminationLatch.await();
    }

    @Test
    @Description(value="Assert that components in an async run in the correct thread according to the flow's PS")
    public void psThreadingPropagated() throws Exception {
        this.terminationLatch = new CountDownLatch(1);
        FlowRunner runner = this.flowRunner("ps-threading-propagated");
        ((BaseEventContext)runner.buildEvent().getContext()).onTerminated((e, t) -> this.terminationLatch.countDown());
        runner.run();
        CoreEvent afterAsyncMessage = this.queueHandler.read("asyncFinished", 1000L);
        Assert.assertThat((Object)afterAsyncMessage, (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)afterAsyncMessage.getMessage().getPayload().getValue().toString(), (Matcher)Matchers.startsWith((String)"[MuleRuntime].cpuIntensive."));
    }

    @Test
    @Description(value="Assert that if no maxConcurrency is configured for an async, the value from the flow is inherited")
    public void withFlowMaxConcurrency() throws Exception {
        this.testAsyncMaxConcurrency("with-flow-max-concurrency");
    }

    @Test
    @Description(value="Assert that asyncs in a sub-flow don't use up the maxConcurrency of the caller flow")
    public void withinSubflowDoesntUseFlowMaxConcurrency() throws Exception {
        int i;
        CountDownLatch latch = new CountDownLatch(1);
        this.runFlows("within-subflow-doesnt-use-flow-max-concurrency", latch);
        for (i = 0; i < 3; ++i) {
            Assert.assertThat((String)("" + i), (Object)this.queueHandler.read("asyncRunning", 1000L), (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        }
        for (i = 0; i < 3; ++i) {
            Assert.assertThat((String)("" + i), (Object)this.queueHandler.read("asyncDispatched", 1000L), (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        }
        latch.countDown();
    }

    private void testAsyncMaxConcurrency(String flowName) throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        this.runFlows(flowName, latch);
        for (int i = 0; i < 2; ++i) {
            Assert.assertThat((String)("" + i), (Object)this.queueHandler.read("asyncRunning", 1000L), (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        }
        Assert.assertThat((Object)this.queueHandler.read("asyncRunning", 1000L), (Matcher)Matchers.nullValue());
        latch.countDown();
        Assert.assertThat((Object)this.queueHandler.read("asyncRunning", 1000L), (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
    }

    private void runFlows(String flowName, CountDownLatch latch) throws Exception {
        this.terminationLatch = new CountDownLatch(3);
        for (int i = 0; i < 3; ++i) {
            FlowRunner runner = (FlowRunner)((FlowRunner)this.flowRunner(flowName).withPayload((Object)i)).withVariable("latch", (Object)latch);
            ((BaseEventContext)runner.buildEvent().getContext()).onTerminated((e, t) -> this.terminationLatch.countDown());
            runner.run();
        }
    }
}

