/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.routing;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.extension.validation.api.ValidationException;
import org.mule.functional.api.component.TestConnectorQueueHandler;
import org.mule.functional.api.exception.ExpectedError;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.message.Message;
import org.mule.test.AbstractIntegrationTestCase;

@Feature(value="Routers")
@Story(value="First Successful")
public class FirstSuccessfulTestCase
extends AbstractIntegrationTestCase {
    @Rule
    public ExpectedError expected = ExpectedError.none();

    protected String getConfigFile() {
        return "first-successful-test.xml";
    }

    @Test
    public void firstRouteWorks() throws Exception {
        Message response = ((FlowRunner)this.flowRunner("test-router").withPayload((Object)"XYZ")).run().getMessage();
        Assert.assertThat((Object)this.getPayloadAsString(response), (Matcher)CoreMatchers.is((Object)"XYZ is a string"));
    }

    @Test
    public void secondRouteWorks() throws Exception {
        Message response = ((FlowRunner)this.flowRunner("test-router").withPayload((Object)9)).run().getMessage();
        Assert.assertThat((Object)this.getPayloadAsString(response), (Matcher)CoreMatchers.is((Object)"9 is a number"));
        response = ((FlowRunner)this.flowRunner("test-router").withPayload((Object)42L)).run().getMessage();
        Assert.assertThat((Object)this.getPayloadAsString(response), (Matcher)CoreMatchers.is((Object)"42 is a number"));
    }

    @Test
    public void allRoutesFail() throws Exception {
        this.expected.expectCause(CoreMatchers.instanceOf(ValidationException.class));
        this.expected.expectErrorType("VALIDATION", "INVALID_BOOLEAN");
        ((FlowRunner)this.flowRunner("test-router").withPayload((Object)Boolean.TRUE)).run().getMessage();
    }

    @Test
    public void oneWayEndpoints() throws Exception {
        ((FlowRunner)this.flowRunner("withOneWayEndpoints").withPayload((Object)"Test Message")).run();
        TestConnectorQueueHandler queueHandler = new TestConnectorQueueHandler(this.registry);
        Message response = queueHandler.read("WithOneWayEndpoints.out", 5000L).getMessage();
        Assert.assertThat((Object)response, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)response.getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"Test Message"));
    }
}

