/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.routing;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import javax.inject.Inject;
import javax.inject.Named;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.metadata.MetadataService;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.test.AbstractIntegrationTestCase;

@Feature(value="Routers")
@Story(value="Round Robin")
public class RoutesLazyInitTestCase
extends AbstractIntegrationTestCase {
    @Inject
    @Named(value="_muleMetadataService")
    private MetadataService metadataService;

    public boolean enableLazyInit() {
        return true;
    }

    public boolean disableXmlValidations() {
        return true;
    }

    protected String getConfigFile() {
        return "lazy-routes.xml";
    }

    @Test
    @Description(value="Resolves metadata from a connector inside of a incomplete Scatter-Gather. In runtime this case fails, but in lazy mode ignores any validation.")
    public void metadataFromElementInsideScatterGather() {
        Location build = Location.builderFromStringRepresentation((String)"select-inside-scatter-gather/processors/0/route/0/processors/0").build();
        MetadataResult operationMetadata = this.metadataService.getOperationMetadata(build);
        MatcherAssert.assertThat((Object)operationMetadata.isSuccess(), (Matcher)CoreMatchers.is((Object)true));
    }
}

