/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.routing;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.io.ByteArrayInputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.IOUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.functional.api.exception.FunctionalTestException;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.functional.junit4.matchers.ThrowableMessageMatcher;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.exception.ComposedErrorException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.tck.junit4.matcher.HasClassInHierarchy;
import org.mule.test.AbstractIntegrationTestCase;

@Feature(value="Routers")
@Story(value="Scatter Gather")
public class ScatterGatherRouterTestCase
extends AbstractIntegrationTestCase {
    private static final String EXCEPTION_MESSAGE_TITLE_PREFIX = "Exception(s) were found for route(s): " + IOUtils.LINE_SEPARATOR;
    private static Set<Thread> capturedThreads;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    protected String getConfigFile() {
        return "scatter-gather-test.xml";
    }

    protected void doSetUp() throws Exception {
        capturedThreads = ConcurrentHashMap.newKeySet();
    }

    @Test
    @Description(value="Minimal configuration with default collect-map strategy.")
    public void minimalConfiguration() throws Exception {
        this.flowRunner("minimalConfig").run();
    }

    @Test
    @Description(value="Minimal configuration with default collect-map strategy and target configured.")
    public void minimalConfigurationTarget() throws Exception {
        this.flowRunner("minimalConfigTarget").run();
    }

    @Test
    @Description(value="Minimal configuration with default collect-map strategy and target configured with targetType Message.")
    public void minimalConfigurationTargetMessage() throws Exception {
        this.flowRunner("minimalConfigTargetMessage").run();
    }

    @Test
    @Description(value="Minimal configuration with default with collect-list strategy configured.")
    public void minimalConfigurationCollectList() throws Exception {
        this.flowRunner("minimalConfigCollectList").run();
    }

    @Test
    @Description(value="Router request fails with runtime exception is payload is consumable.")
    public void consumablePayload() throws Exception {
        this.expectedException.expectCause(CoreMatchers.instanceOf(MuleRuntimeException.class));
        this.expectedException.expectCause(ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.startsWith((String)"Cannot copy message with a stream payload")));
        ((FlowRunner)this.flowRunner("minimalConfig").withPayload((Object)new ByteArrayInputStream("hello world".getBytes()))).run();
    }

    @Test
    @Description(value="Router times out if routes take longer than the timeout configured to complete.")
    public void timeout() throws Exception {
        this.expectedException.expectCause(HasClassInHierarchy.withClassName((String)"org.mule.runtime.core.privileged.routing.CompositeRoutingException"));
        this.flowRunner("timeout").run();
    }

    @Test
    @Description(value="An error in a route results in a CompositeRoutingException containing details of exceptions.")
    public void routeWithException() throws Exception {
        this.assertRouteException("routeWithException", EXCEPTION_MESSAGE_TITLE_PREFIX + "\t1: org.mule.functional.api.exception.FunctionalTestException: Functional Test Service Exception", FunctionalTestException.class);
    }

    @Test
    @Description(value="An error in a route results in a CompositeRoutingException containing details of exceptions.")
    public void routeWithExceptionWithMessage() throws Exception {
        this.assertRouteException("routeWithExceptionWithMessage", EXCEPTION_MESSAGE_TITLE_PREFIX + "\t1: org.mule.functional.api.exception.FunctionalTestException: I'm a message", FunctionalTestException.class);
    }

    @Test
    @Description(value="An error in a route results in a CompositeRoutingException containing details of exceptions.")
    public void routeWithNonMuleException() throws Exception {
        this.assertRouteException("routeWithNonMuleException", EXCEPTION_MESSAGE_TITLE_PREFIX + "\t1: java.lang.NullPointerException: nonMule", NullPointerException.class);
    }

    @Test
    @Description(value="An error in a route results in a CompositeRoutingException containing details of exceptions.")
    public void routeWithExpressionException() throws Exception {
        this.assertRouteException("routeWithExpressionException", EXCEPTION_MESSAGE_TITLE_PREFIX + "\t1: org.mule.runtime.core.api.expression.ExpressionRuntimeException: \"Script 'invalidExpr ' has errors: \n\tUnable to resolve reference of invalidExpr. at 1 : 1\" evaluating expression: \"invalidExpr\".", ExpressionRuntimeException.class);
    }

    @Test
    @Description(value="An error in a route when executing sequentially results in a CompositeRoutingException containing details of exceptions.")
    public void routeWithExceptionInSequentialProcessing() throws Exception {
        this.assertRouteException("routeWithExceptionInSequentialProcessing", EXCEPTION_MESSAGE_TITLE_PREFIX + "\t1: org.mule.functional.api.exception.FunctionalTestException: Functional Test Service Exception", FunctionalTestException.class);
    }

    private void assertRouteException(String flow, String exceptionMessageStart, Class exceptionType) throws Exception {
        try {
            this.flowRunner(flow).run();
            Assert.fail((String)"Was expecting a failure");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e.getCause(), (Matcher)HasClassInHierarchy.withClassName((String)"org.mule.runtime.core.privileged.routing.CompositeRoutingException"));
            Throwable compositeRoutingException = e.getCause();
            Assert.assertThat((Object)compositeRoutingException.getMessage(), (Matcher)CoreMatchers.startsWith((String)exceptionMessageStart));
            List exceptions = ((ComposedErrorException)compositeRoutingException).getErrors();
            Assert.assertThat((Object)exceptions, (Matcher)Matchers.hasSize((int)1));
            Assert.assertThat((Object)((Error)exceptions.get(0)).getCause(), (Matcher)CoreMatchers.instanceOf((Class)exceptionType));
        }
    }

    @Test
    @Description(value="Only sa single thread is used to process all routes when configured with maxConcurrency=1.")
    public void sequentialProcessing() throws Exception {
        ((FlowRunner)this.flowRunner("sequentialProcessing").withVariable("latch", (Object)new Latch())).run();
        Assert.assertThat(capturedThreads, (Matcher)Matchers.hasSize((int)1));
    }

    @Test
    @Description(value="The result of all route failures and results are available via errorMessage in error-handler..")
    public void errorHandler() throws Exception {
        this.flowRunner("errorHandler").run();
    }

    @Test
    @Description(value="Variables set before route are conserved after router. Variables set in routes are merged and available after router.")
    public void variables() throws Exception {
        this.flowRunner("variables").run();
    }

    @Test
    @Description(value="By default routes are run concurrently and multiple threads are used.")
    public void concurrent() throws Exception {
        ((FlowRunner)this.flowRunner("concurrent").withVariable("latch", (Object)new Latch())).run();
        Assert.assertThat(capturedThreads, (Matcher)Matchers.hasSize((int)3));
    }

    @Test
    @Description(value="The resulting Map<String, Message result maintains the correct data-type for each Message.")
    public void returnsCorrectDataType() throws Exception {
        Message response = ((FlowRunner)this.flowRunner("dataType").withMediaType(MediaType.JSON)).run().getMessage();
        Assert.assertThat((Object)response.getPayload().getValue(), (Matcher)CoreMatchers.is((Matcher)Matchers.instanceOf(Map.class)));
        Map messageList = (Map)response.getPayload().getValue();
        Assert.assertThat((Object)messageList.size(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)((Message)messageList.get("0")).getPayload().getDataType().getMediaType(), (Matcher)CoreMatchers.is((Object)MediaType.TEXT));
        Assert.assertThat((Object)((Message)messageList.get("1")).getPayload().getDataType().getMediaType(), (Matcher)CoreMatchers.is((Object)MediaType.ANY));
        Assert.assertThat((Object)((Message)messageList.get("2")).getPayload().getDataType().getMediaType(), (Matcher)CoreMatchers.is((Object)MediaType.ANY));
    }

    public static class ThreadCaptor
    extends AbstractComponent
    implements Processor {
        public CoreEvent process(CoreEvent event) throws MuleException {
            Latch latch;
            capturedThreads.add(Thread.currentThread());
            if (capturedThreads.size() > 2 && (latch = (Latch)((TypedValue)event.getVariables().get("latch")).getValue()) != null) {
                latch.release();
            }
            return event;
        }
    }
}

