/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.routing;

import com.google.common.collect.ConcurrentHashMultiset;
import com.google.common.collect.Multiset;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.test.AbstractIntegrationTestCase;

@Feature(value="Routers")
@Story(value="Until Successful")
public class UntilSuccessfulWithSplitterTestCase
extends AbstractIntegrationTestCase {
    private static final int TIMEOUT = 5;
    private static Multiset<String> seenPayloads;
    private static CountDownLatch latch;

    protected String getConfigFile() {
        return "until-successful-with-splitter.xml";
    }

    protected void doSetUp() throws Exception {
        seenPayloads = ConcurrentHashMultiset.create();
        latch = new CountDownLatch(2);
    }

    @Test
    public void withSplitter() throws Exception {
        this.runFlow("withSplitter");
        Assert.assertThat((Object)latch.await(5L, TimeUnit.SECONDS), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)seenPayloads.count((Object)"a"), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)seenPayloads.count((Object)"b"), (Matcher)CoreMatchers.is((Object)2));
    }

    public static class FailAtFirstAttempt
    implements Processor {
        public CoreEvent process(CoreEvent event) throws MuleException {
            String payload = event.getMessage().getPayload().getValue().toString();
            seenPayloads.add((Object)payload);
            if (seenPayloads.count((Object)payload) == 1) {
                throw new RuntimeException("first time");
            }
            latch.countDown();
            return event;
        }
    }
}

