/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.spring;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.tests.parsers.api.LifecycleAction;
import org.mule.tests.parsers.api.LifecycleSensingMessageProcessor;
import org.mule.tests.parsers.api.LifecycleSensingObjectFactory;

public class ComponentLifecycleTestCase
extends AbstractIntegrationTestCase {
    protected String getConfigFile() {
        return "org/mule/test/spring/component-lifecycle-config.xml";
    }

    @Test
    public void globalElementLifecycle() {
        LifecycleSensingMessageProcessor lifecycleSensingMessageProcessor = (LifecycleSensingMessageProcessor)this.registry.lookupByName("globalElement").get();
        this.assertObjectFactoryAndMessageProcessorLifecycle(lifecycleSensingMessageProcessor);
    }

    @Test
    public void innerElementLifecycle() {
        Flow flow = (Flow)this.registry.lookupByName("flow").get();
        LifecycleSensingMessageProcessor lifecycleSensingMessageProcessor = (LifecycleSensingMessageProcessor)flow.getProcessors().get(0);
        this.assertObjectFactoryAndMessageProcessorLifecycle(lifecycleSensingMessageProcessor);
    }

    private void assertObjectFactoryAndMessageProcessorLifecycle(LifecycleSensingMessageProcessor lifecycleSensingMessageProcessor) {
        LifecycleSensingObjectFactory lifecycleSensingObjectFactory = lifecycleSensingMessageProcessor.getObjectFactory();
        Assert.assertThat((Object)lifecycleSensingObjectFactory.getLifecycleActions(), (Matcher)Matchers.hasItems((Object[])new LifecycleAction[]{LifecycleAction.GET_OBJECT}));
        Assert.assertThat((Object)lifecycleSensingMessageProcessor.getLifecycleActions(), (Matcher)Matchers.hasItems((Object[])new LifecycleAction[]{LifecycleAction.INITIALISE, LifecycleAction.START}));
        muleContext.dispose();
        Assert.assertThat((Object)lifecycleSensingObjectFactory.getLifecycleActions(), (Matcher)Matchers.hasItems((Object[])new LifecycleAction[]{LifecycleAction.GET_OBJECT}));
        Assert.assertThat((Object)lifecycleSensingMessageProcessor.getLifecycleActions(), (Matcher)Matchers.hasItems((Object[])new LifecycleAction[]{LifecycleAction.INITIALISE, LifecycleAction.START, LifecycleAction.STOP, LifecycleAction.DISPOSE}));
    }
}

