/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.spring;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Test;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.tests.parsers.api.TestObject;
import org.mule.tests.parsers.api.TestObjectFactory;

@Feature(value="Lifecycle and Dependency Injection")
@Story(value="Object Factory Injection And Lifecycle")
public class ObjectFactoryTestCase
extends AbstractIntegrationTestCase {
    protected String getConfigFile() {
        return "org/mule/test/spring/object-factory-config.xml";
    }

    @Test
    public void validateInjectionAndLifecycleOverObjectFactoryAndTheObjectCreatedByIt() {
        TestObject testObject = (TestObject)this.registry.lookupByType(TestObject.class).get();
        Assert.assertThat((Object)testObject, (Matcher)IsNull.notNullValue());
        TestObjectFactory objectFactory = testObject.getObjectFactory();
        Assert.assertThat((Object)objectFactory.isInjectionDoneBeforeGetObject(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)objectFactory.getLifecycleActions().isEmpty(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)testObject.getLockFactory(), (Matcher)IsNull.nullValue());
        muleContext.dispose();
        Assert.assertThat((Object)testObject.getLifecycleActions(), (Matcher)Matchers.contains((Object[])new String[]{"initialise", "start", "stop", "dispose"}));
        Assert.assertThat((Object)objectFactory.getLifecycleActions().isEmpty(), (Matcher)Is.is((Object)true));
    }
}

