/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.spring.security;

import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.test.AbstractIntegrationTestCase;

public class AuthenticationAgainstMultipleProvidersTestCase
extends AbstractIntegrationTestCase {
    @Rule
    public DynamicPort httpPort1 = new DynamicPort("port1");
    @Rule
    public DynamicPort httpPort2 = new DynamicPort("port2");
    @Rule
    public DynamicPort httpPort3 = new DynamicPort("port3");

    protected String getConfigFile() {
        return "org/mule/test/spring/security/mule-multiple-providers-config-flow.xml";
    }

    @Test
    public void testProvider1() throws Exception {
        HttpClient httpClient = new HttpClient();
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials("admin1", "admin1");
        httpClient.getState().setCredentials(AuthScope.ANY, (Credentials)credentials);
        httpClient.getParams().setAuthenticationPreemptive(true);
        PostMethod postMethod = new PostMethod("http://localhost:" + this.httpPort1.getNumber());
        postMethod.setDoAuthentication(true);
        postMethod.setRequestEntity((RequestEntity)new StringRequestEntity("hello", "text/html", "UTF-8"));
        Assert.assertEquals((long)200L, (long)httpClient.executeMethod((HttpMethod)postMethod));
        Assert.assertEquals((Object)"hello", (Object)postMethod.getResponseBodyAsString());
        credentials = new UsernamePasswordCredentials("asdf", "asdf");
        httpClient.getState().setCredentials(AuthScope.ANY, (Credentials)credentials);
        Assert.assertEquals((long)401L, (long)httpClient.executeMethod((HttpMethod)postMethod));
        credentials = new UsernamePasswordCredentials("admin2", "admin2");
        httpClient.getState().setCredentials(AuthScope.ANY, (Credentials)credentials);
        Assert.assertEquals((long)401L, (long)httpClient.executeMethod((HttpMethod)postMethod));
    }

    @Test
    public void testProvider2() throws Exception {
        HttpClient httpClient = new HttpClient();
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials("admin2", "admin2");
        httpClient.getState().setCredentials(AuthScope.ANY, (Credentials)credentials);
        httpClient.getParams().setAuthenticationPreemptive(true);
        PostMethod postMethod = new PostMethod("http://localhost:" + this.httpPort2.getNumber());
        postMethod.setDoAuthentication(true);
        postMethod.setRequestEntity((RequestEntity)new StringRequestEntity("hello", "text/html", "UTF-8"));
        Assert.assertEquals((long)200L, (long)httpClient.executeMethod((HttpMethod)postMethod));
        Assert.assertEquals((Object)"hello", (Object)postMethod.getResponseBodyAsString());
        credentials = new UsernamePasswordCredentials("asdf", "asdf");
        httpClient.getState().setCredentials(AuthScope.ANY, (Credentials)credentials);
        Assert.assertEquals((long)401L, (long)httpClient.executeMethod((HttpMethod)postMethod));
        credentials = new UsernamePasswordCredentials("admin", "admin");
        httpClient.getState().setCredentials(AuthScope.ANY, (Credentials)credentials);
        Assert.assertEquals((long)401L, (long)httpClient.executeMethod((HttpMethod)postMethod));
    }

    @Test
    public void testMultipleProviders() throws Exception {
        HttpClient httpClient = new HttpClient();
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials("admin1", "admin1");
        httpClient.getState().setCredentials(AuthScope.ANY, (Credentials)credentials);
        httpClient.getParams().setAuthenticationPreemptive(true);
        PostMethod postMethod = new PostMethod("http://localhost:" + this.httpPort3.getNumber());
        postMethod.setDoAuthentication(true);
        postMethod.setRequestEntity((RequestEntity)new StringRequestEntity("hello", "text/html", "UTF-8"));
        Assert.assertEquals((long)200L, (long)httpClient.executeMethod((HttpMethod)postMethod));
        Assert.assertEquals((Object)"hello", (Object)postMethod.getResponseBodyAsString());
        credentials = new UsernamePasswordCredentials("asdf", "asdf");
        httpClient.getState().setCredentials(AuthScope.ANY, (Credentials)credentials);
        Assert.assertEquals((long)401L, (long)httpClient.executeMethod((HttpMethod)postMethod));
        credentials = new UsernamePasswordCredentials("admin2", "admin2");
        httpClient.getState().setCredentials(AuthScope.ANY, (Credentials)credentials);
        Assert.assertEquals((long)200L, (long)httpClient.executeMethod((HttpMethod)postMethod));
        Assert.assertEquals((Object)"hello", (Object)postMethod.getResponseBodyAsString());
    }
}

